/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.model;

import de.justsoftware.permission.client.model.Role;
import de.justsoftware.wikiservice.model.GranteeId;
import de.justsoftware.wikiservice.model.ProfileId;
import jakarta.persistence.Embeddable;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MappedSuperclass
@Embeddable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\u0007J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u0006H\u0016J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0005\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/wikiservice/model/ProfileId;", "Ljava/io/Serializable;", "id", "", "<init>", "(J)V", "", "(Ljava/lang/String;)V", "getId", "()J", "setId", "toRole", "Lde/justsoftware/permission/client/model/Role;", "toGranteeId", "Lde/justsoftware/wikiservice/model/GranteeId;", "toString", "component1", "copy", "equals", "", "other", "", "hashCode", "", "Companion", "wiki-service"})
public final class ProfileId
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long id;

    public ProfileId(long id) {
        this.id = id;
    }

    public final long getId() {
        return this.id;
    }

    public final void setId(long l) {
        this.id = l;
    }

    public ProfileId(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Role role = Role.create((String)id);
        Intrinsics.checkNotNullExpressionValue((Object)role, (String)"create(...)");
        ProfileId profileId = Companion.toProfileId(role);
        if (profileId == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        this(profileId.id);
    }

    @NotNull
    public final Role toRole() {
        Role role = Role.profileRole((long)this.id);
        Intrinsics.checkNotNullExpressionValue((Object)role, (String)"profileRole(...)");
        return role;
    }

    @NotNull
    public final GranteeId toGranteeId() {
        return GranteeId.Companion.toGranteeId(this.toRole());
    }

    @NotNull
    public String toString() {
        return "PROFILE," + this.id;
    }

    public final long component1() {
        return this.id;
    }

    @NotNull
    public final ProfileId copy(long id) {
        return new ProfileId(id);
    }

    public static /* synthetic */ ProfileId copy$default(ProfileId profileId, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = profileId.id;
        }
        return profileId.copy(l);
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProfileId)) {
            return false;
        }
        ProfileId profileId = (ProfileId)other;
        return this.id == profileId.id;
    }

    public ProfileId() {
    }
}

