/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.graphql.fetchers;

import de.justsoftware.wikiservice.application.UserInfoApplicationService;
import de.justsoftware.wikiservice.application.model.WikiDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.graphql.AuthenticatedGraphQLContext;
import de.justsoftware.wikiservice.graphql.dataloader.DataLoaderFactory;
import de.justsoftware.wikiservice.graphql.dataloader.DataLoaderName;
import de.justsoftware.wikiservice.model.WikiId;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0017J\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0017J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\n\u001a,\u0012(\u0012&\u0012\f\u0012\n \r*\u0004\u0018\u00010\t0\t \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\t0\t\u0018\u00010\f0\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000eR>\u0010\u0010\u001a,\u0012(\u0012&\u0012\f\u0012\n \r*\u0004\u0018\u00010\t0\t \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\t0\t\u0018\u00010\f0\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR>\u0010\u0012\u001a,\u0012(\u0012&\u0012\f\u0012\n \r*\u0004\u0018\u00010\t0\t \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\t0\t\u0018\u00010\f0\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lde/justsoftware/wikiservice/graphql/fetchers/UserInfoFetcher;", "", "userInfoApplicationService", "Lde/justsoftware/wikiservice/application/UserInfoApplicationService;", "<init>", "(Lde/justsoftware/wikiservice/application/UserInfoApplicationService;)V", "isManagerDataLoaderFactory", "Lde/justsoftware/wikiservice/graphql/dataloader/DataLoaderFactory;", "Lde/justsoftware/wikiservice/model/WikiId;", "", "isManager", "Lgraphql/schema/DataFetcher;", "Ljava/util/concurrent/CompletableFuture;", "kotlin.jvm.PlatformType", "()Lgraphql/schema/DataFetcher;", "isWriterDataLoaderFactory", "isWriter", "mayReadArticleVersionHistoryDataLoaderFactory", "mayReadArticleVersionHistory", "getMayReadArticleVersionHistory", "wiki-service"})
public class UserInfoFetcher {
    @NotNull
    private final UserInfoApplicationService userInfoApplicationService;
    @NotNull
    private final DataFetcher<CompletableFuture<Boolean>> isManager;
    @NotNull
    private final DataFetcher<CompletableFuture<Boolean>> isWriter;
    @NotNull
    private final DataFetcher<CompletableFuture<Boolean>> mayReadArticleVersionHistory;

    @Autowired
    public UserInfoFetcher(@NotNull UserInfoApplicationService userInfoApplicationService) {
        Intrinsics.checkNotNullParameter((Object)userInfoApplicationService, (String)"userInfoApplicationService");
        this.userInfoApplicationService = userInfoApplicationService;
        this.isManager = UserInfoFetcher::isManager$lambda$1;
        this.isWriter = UserInfoFetcher::isWriter$lambda$3;
        this.mayReadArticleVersionHistory = UserInfoFetcher::mayReadArticleVersionHistory$lambda$5;
    }

    @Bean
    @NotNull
    public DataLoaderFactory<WikiId, Boolean> isManagerDataLoaderFactory() {
        return new DataLoaderFactory(DataLoaderName.IS_MANAGER_LOADER, (arg_0, arg_1) -> UserInfoFetcher.isManagerDataLoaderFactory$lambda$0(this, arg_0, arg_1));
    }

    @NotNull
    public DataFetcher<CompletableFuture<Boolean>> isManager() {
        return this.isManager;
    }

    @Bean
    @NotNull
    public DataLoaderFactory<WikiId, Boolean> isWriterDataLoaderFactory() {
        return new DataLoaderFactory(DataLoaderName.IS_WRITER_LOADER, (arg_0, arg_1) -> UserInfoFetcher.isWriterDataLoaderFactory$lambda$2(this, arg_0, arg_1));
    }

    @NotNull
    public DataFetcher<CompletableFuture<Boolean>> isWriter() {
        return this.isWriter;
    }

    @Bean
    @NotNull
    public DataLoaderFactory<WikiId, Boolean> mayReadArticleVersionHistoryDataLoaderFactory() {
        return new DataLoaderFactory(DataLoaderName.MAY_READ_ARTICLE_VERSION_HISTORY, (arg_0, arg_1) -> UserInfoFetcher.mayReadArticleVersionHistoryDataLoaderFactory$lambda$4(this, arg_0, arg_1));
    }

    @NotNull
    public DataFetcher<CompletableFuture<Boolean>> getMayReadArticleVersionHistory() {
        return this.mayReadArticleVersionHistory;
    }

    private static final Map isManagerDataLoaderFactory$lambda$0(UserInfoFetcher this$0, List wikiIds, AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this$0.userInfoApplicationService.isManager(wikiIds, authContext.getUser());
    }

    private static final CompletableFuture isManager$lambda$1(DataFetchingEnvironment data) {
        AuthenticatedGraphQLContext ctx = (AuthenticatedGraphQLContext)data.getContext();
        DataLoader dataLoader = ctx.getDataLoader(DataLoaderName.IS_MANAGER_LOADER);
        WikiId wikiId = ((WikiDto)data.getLocalContext()).getId();
        return dataLoader.load((Object)wikiId);
    }

    private static final Map isWriterDataLoaderFactory$lambda$2(UserInfoFetcher this$0, List wikiIds, AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this$0.userInfoApplicationService.isWriter(wikiIds, authContext.getUser());
    }

    private static final CompletableFuture isWriter$lambda$3(DataFetchingEnvironment data) {
        AuthenticatedGraphQLContext ctx = (AuthenticatedGraphQLContext)data.getContext();
        DataLoader dataLoader = ctx.getDataLoader(DataLoaderName.IS_WRITER_LOADER);
        WikiId wikiId = ((WikiDto)data.getLocalContext()).getId();
        return dataLoader.load((Object)wikiId);
    }

    private static final Map mayReadArticleVersionHistoryDataLoaderFactory$lambda$4(UserInfoFetcher this$0, List wikiIds, AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this$0.userInfoApplicationService.mayReadArticleVersionHistory(wikiIds, authContext);
    }

    private static final CompletableFuture mayReadArticleVersionHistory$lambda$5(DataFetchingEnvironment data) {
        AuthenticatedGraphQLContext ctx = (AuthenticatedGraphQLContext)data.getContext();
        DataLoader dataLoader = ctx.getDataLoader(DataLoaderName.MAY_READ_ARTICLE_VERSION_HISTORY);
        WikiId wikiId = ((WikiDto)data.getLocalContext()).getId();
        return dataLoader.load((Object)wikiId);
    }
}

