/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.application.SubscriptionApplicationService;
import de.justsoftware.wikiservice.application.model.SubscriptionDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.SubscriptionService;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.model.Subscription;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ*\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\f\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\f\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lde/justsoftware/wikiservice/application/SubscriptionApplicationService;", "", "subscriptionService", "Lde/justsoftware/wikiservice/business/SubscriptionService;", "chapterService", "Lde/justsoftware/wikiservice/business/ChapterService;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "authorizationService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "<init>", "(Lde/justsoftware/wikiservice/business/SubscriptionService;Lde/justsoftware/wikiservice/business/ChapterService;Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/authorization/AuthorizationService;)V", "read", "", "Lde/justsoftware/wikiservice/model/WikiId;", "Lde/justsoftware/wikiservice/application/model/SubscriptionDto;", "wikiIds", "", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "chapterId", "Lde/justsoftware/wikiservice/model/ChapterId;", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "setSubscription", "itemId", "Lde/justsoftware/wikiservice/model/ItemId;", "isSubscribed", "", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nSubscriptionApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubscriptionApplicationService.kt\nde/justsoftware/wikiservice/application/SubscriptionApplicationService\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n462#2:73\n412#2:74\n1246#3,4:75\n*S KotlinDebug\n*F\n+ 1 SubscriptionApplicationService.kt\nde/justsoftware/wikiservice/application/SubscriptionApplicationService\n*L\n30#1:73\n30#1:74\n30#1:75,4\n*E\n"})
public class SubscriptionApplicationService {
    @NotNull
    private final SubscriptionService subscriptionService;
    @NotNull
    private final ChapterService chapterService;
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final AuthorizationService authorizationService;

    @Autowired
    public SubscriptionApplicationService(@NotNull SubscriptionService subscriptionService, @NotNull ChapterService chapterService, @NotNull ArticleService articleService, @NotNull AuthorizationService authorizationService) {
        Intrinsics.checkNotNullParameter((Object)subscriptionService, (String)"subscriptionService");
        Intrinsics.checkNotNullParameter((Object)chapterService, (String)"chapterService");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        this.subscriptionService = subscriptionService;
        this.chapterService = chapterService;
        this.articleService = articleService;
        this.authorizationService = authorizationService;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<WikiId, SubscriptionDto> read(@NotNull List<WikiId> wikiIds, @NotNull AuthContext authContext) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Set userRoles = this.authorizationService.getUserRoles(authContext.getUser());
        Map map = this.subscriptionService.readWikis(CollectionsKt.toSet((Iterable)wikiIds), authContext.getUser(), userRoles);
        boolean $i$f$mapValues = false;
        void var6_6 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void entry;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            SubscriptionDto subscriptionDto = SubscriptionDto.Companion.toDto((Subscription)entry.getValue());
            map3.put(k, subscriptionDto);
        }
        return destination$iv$iv;
    }

    @NotNull
    public SubscriptionDto read(@NotNull ChapterId chapterId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        WikiId wikiId = this.chapterService.read(chapterId).getWikiId();
        authContext.checkReadWiki(wikiId);
        return SubscriptionDto.Companion.toDto(this.subscriptionService.readChapter(chapterId, authContext.getUser()));
    }

    @NotNull
    public SubscriptionDto read(@NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        WikiId wikiId = this.articleService.read(articleId).getWikiId();
        authContext.checkReadWiki(wikiId);
        return SubscriptionDto.Companion.toDto(this.subscriptionService.readArticle(articleId, authContext.getUser()));
    }

    @NotNull
    public SubscriptionDto setSubscription(@NotNull ItemId itemId, boolean isSubscribed, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        switch (WhenMappings.$EnumSwitchMapping$0[itemId.type().ordinal()]) {
            case 1: {
                authContext.checkReadWiki((WikiId)itemId);
                break;
            }
            case 2: {
                WikiId wikiId = this.chapterService.read((ChapterId)itemId).getWikiId();
                authContext.checkReadWiki(wikiId);
                break;
            }
            case 3: {
                WikiId wikiId = this.articleService.read((ArticleId)itemId).getWikiId();
                authContext.checkReadWiki(wikiId);
                break;
            }
            default: {
                throw new RuntimeException("Cannot subscribe to " + itemId);
            }
        }
        return SubscriptionDto.Companion.toDto(this.subscriptionService.setSubscription(itemId, authContext.getUser(), isSubscribed));
    }
}

