/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.wikieditor.presentation.client;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.shared.util.UrlUtil;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.SaveCKResult;
import de.justsoftware.onx.wikieditor.presentation.client.WikiEditorMediator;
import de.justsoftware.onx.wikieditor.presentation.client.WikiEditorMediatorInterface;
import de.justsoftware.onx.wikieditor.presentation.shared.WikiEditorRemoteService;
import de.justsoftware.onx.wikieditor.presentation.shared.WikiEditorRemoteServiceAsync;
import de.justsoftware.onx.wikieditor.shared.i18n.WikiEditorConstants;
import de.justsoftware.onx.wikieditor.shared.i18n.WikiEditorMessages;
import de.justsoftware.onx.wikieditor.shared.model.DBWikiBackup;
import de.justsoftware.onx.wikieditor.shared.model.WikiBackupTeaser;
import de.justsoftware.onx.wikieditor.shared.model.WikiEditor;
import de.justsoftware.onx.wikieditor.shared.model.WikiEditorId;
import de.justsoftware.onx.wikieditor.shared.model.WikiPreEditResult;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersion;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionBadge;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionId;

public class WikiEditorMediatorImpl
implements WikiEditorMediatorInterface {
    private static final BasicConstants BASIC = I18nMediator.BASIC_CONSTANTS;
    private static final WikiEditorConstants WIKI_EDITOR = I18nMediator.WIKI_EDITOR;
    private static final WikiEditorMessages WIKI_EDITOR_MSG = I18nMediator.WIKI_EDITOR_MSG;
    private final WikiEditorRemoteServiceAsync _remoteService = (WikiEditorRemoteServiceAsync)GWT.create(WikiEditorRemoteService.class);

    public WikiEditorMediatorImpl() {
        UrlUtil.setRemoteServiceUrl((Object)this._remoteService, (String)"/wikieditor");
    }

    public void getWikiBackup(WikiEditorId id, AsyncCallback<DBWikiBackup> callback) {
        this._remoteService.getWikiBackup(id, callback);
    }

    public void getWikiBackupTeaser(WikiEditorId id, AsyncCallback<WikiBackupTeaser> callback) {
        this._remoteService.getWikiBackupTeaser(id, callback);
    }

    public void getWikiVersion(WikiVersionId id, AsyncCallback<WikiVersion> callback) {
        this._remoteService.getWikiVersion(id, callback);
    }

    public void getWikiVersionDiff(WikiVersionId oldId, WikiVersionId newId, AsyncCallback<String> callback) {
        this._remoteService.getWikiVersionDiff(oldId, newId, callback);
    }

    public void getWikiVersionBadges(WikiEditorId id, int offset, int limit, AsyncCallback<ListAndCount<WikiVersionBadge>> callback) {
        this._remoteService.getWikiVersionBadges(id, offset, limit, callback);
    }

    public void saveWikiBackup(WikiEditorId id, String text, AsyncCallback<Void> callback) {
        this._remoteService.saveWikiBackup(id, text, callback);
    }

    public void deleteWikiBackup(WikiEditorId id, AsyncCallback<Void> callback) {
        this._remoteService.deleteWikiBackup(id, callback);
    }

    public void deleteWikiVersion(WikiVersionId id, AsyncCallback<Void> callback) {
        this._remoteService.deleteWikiVersion(id, callback);
    }

    public void getCurrentWikiVersion(WikiEditorId id, AsyncCallback<WikiVersion> callback) {
        this._remoteService.getCurrentWikiVersion(id, callback);
    }

    public void restoreVersion(WikiVersionId id, AsyncCallback<Void> callback) {
        this._remoteService.restoreVersion(id, callback);
    }

    public void getWikiEditorById(WikiEditorId id, AsyncCallback<WikiEditor> callback) {
        this._remoteService.getWikiEditorById(id, callback);
    }

    public void saveWikiVersion(WikiEditorId id, String text, boolean sendSubscriberNotification, AsyncCallback<SaveCKResult> callback) {
        this._remoteService.saveWikiVersion(id, text, sendSubscriberNotification, callback);
    }

    public void checkLock(WikiEditorId id, ClickHandler onSave) {
        WikiEditorMediator.getInstance().getWikiBackupTeaser(id, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void preEditCheck(WikiEditorId id, WikiVersionId versionId, AsyncCallback<WikiPreEditResult> callback) {
        this._remoteService.preEditCheck(id, versionId, callback);
    }
}

