/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.presentation.client.ui.EntityOverviewHandler;
import de.justsoftware.onx.container.presentation.client.ui.ReactProfileComponent;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.NewsChannelId;
import de.justsoftware.onx.container.shared.model.NewsPostId;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.searchnew.shared.model.ArticleSuggest;
import de.justsoftware.onx.searchnew.shared.model.ChapterSuggest;
import de.justsoftware.onx.searchnew.shared.model.ChatSuggest;
import de.justsoftware.onx.searchnew.shared.model.DriveDocumentSuggest;
import de.justsoftware.onx.searchnew.shared.model.EntitySuggest;
import de.justsoftware.onx.searchnew.shared.model.NewsChannelSuggest;
import de.justsoftware.onx.searchnew.shared.model.NewsPostSuggest;
import de.justsoftware.onx.searchnew.shared.model.PersonSuggest;
import de.justsoftware.onx.searchnew.shared.model.SearchSuggestModelVisitor;
import de.justsoftware.onx.searchnew.shared.model.WikiSuggest;
import de.justsoftware.onx.searchnew.shared.model.WorkstreamSuggest;
import de.justsoftware.onx.workstream.presentation.client.ui.WorkstreamMessageHandler;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class HistoryTokenSearchSuggestModelVisitor
implements SearchSuggestModelVisitor<String> {
    private final String _suggestQuery;
    private final ClientFactory _clientFactory;

    public HistoryTokenSearchSuggestModelVisitor(@Nullable String suggestQuery, ClientFactory clientFactory) {
        this._suggestQuery = suggestQuery;
        this._clientFactory = clientFactory;
    }

    @Nonnull
    public String visitEntity(EntitySuggest entity) {
        return EntityOverviewHandler.token((EntityId)((EntityId)entity.getId()));
    }

    @Nonnull
    public String visitPerson(PersonSuggest person) {
        return ReactProfileComponent.token((PersonId)((PersonId)person.getId()));
    }

    @Nonnull
    public String visitWorkstream(WorkstreamSuggest workstream) {
        return WorkstreamMessageHandler.token((WorkstreamMessageId)((WorkstreamMessageId)workstream.getId()));
    }

    public String visitNewsPost(NewsPostSuggest suggest) {
        return "/news/posts/" + ((NewsPostId)suggest.getId()).getId();
    }

    public String visitNewsChannel(NewsChannelSuggest suggest) {
        return "/news/channel/" + ((NewsChannelId)suggest.getId()).getId();
    }

    public String visitChat(ChatSuggest chat) {
        return "/chat/" + chat.getId();
    }

    public String visitDriveDocument(DriveDocumentSuggest driveDocument) {
        return this._clientFactory.driveFactory().getHistoryToken((DriveDocumentId)driveDocument.getId(), driveDocument.getDocumentType(), driveDocument.getParentId());
    }

    public String visitWiki(WikiSuggest wikiSuggest) {
        return "wiki/wikis/" + wikiSuggest.getId();
    }

    public String visitChapter(ChapterSuggest chapterSuggest) {
        return "wiki/chapters/" + chapterSuggest.getId();
    }

    public String visitArticle(ArticleSuggest articleSuggest) {
        return "wiki/articles/" + articleSuggest.getId();
    }
}

