/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.freiheit.toro.common.presentation.ui.HTMLUtil;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.InlineHyperlink;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.JCIconOnlyAnchor;
import de.justsoftware.onx.container.shared.model.SearchableId;
import de.justsoftware.onx.searchnew.presentation.client.SearchTrackingInfo;
import de.justsoftware.onx.searchnew.presentation.client.ui.BaseSearchResultBadgePresenter;
import de.justsoftware.onx.searchnew.shared.model.ChapterSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.WikiInfo;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ChapterSearchResultBadgePresenter
extends BaseSearchResultBadgePresenter {
    public ChapterSearchResultBadgePresenter(ClientFactory clientFactory, ChapterSearchResultBadgeModel model, boolean displayParents, boolean displayContextSwitch, @Nullable SearchTrackingInfo searchTrackingInfo, @Nullable String additionalOverlayStyleName) {
        super(clientFactory, displayContextSwitch, (SearchableId)model.getId(), searchTrackingInfo, additionalOverlayStyleName);
        this.setIcon(model);
        this.setTitle(model);
        this.setParent(model);
        this._view.setParentEnabled(displayParents);
        this.setLastChangeDate(model.getModifyDate());
    }

    private void setTitle(ChapterSearchResultBadgeModel model) {
        String targetHistoryToken = this.token(model);
        String name = model.getName();
        if (name != null) {
            InlineHyperlink link = new InlineHyperlink(name, targetHistoryToken);
            link.setHTML(HTMLUtil.highlightedHtmlEscape((String)name));
            link.setTitle(HTMLUtil.removeHighlightTag((String)name));
            this._view.setTitleWidget(link);
        }
    }

    private void setParent(ChapterSearchResultBadgeModel model) {
        FlowPanel parentWidget = new FlowPanel();
        WikiInfo wikiInfo = model.getWikiInfo();
        if (wikiInfo != null) {
            InlineHyperlink link = new InlineHyperlink(wikiInfo.getWikiName(), "/wiki/wikis/" + wikiInfo.getWikiId());
            parentWidget.add((Widget)link);
            this._view.setParentWidget((Widget)parentWidget);
        }
    }

    @Nonnull
    private String token(ChapterSearchResultBadgeModel model) {
        return ("/wiki/chapters/" + model.getId()).replace("WIKI_CHAPTER,", "WIKI_CHAPTER%2C");
    }

    private void setIcon(ChapterSearchResultBadgeModel model) {
        JCIconOnlyAnchor icon = new JCIconOnlyAnchor(IconType.BOOKMARK, this.token(model));
        icon.addStyleName("action");
        icon.addStyleName("badgeIcon");
        icon.addStyleName("app-wiki-color");
        icon.setTitle(HTMLUtil.removeHighlightTag((String)model.getName()));
        this._view.setIconWidget((Widget)icon);
    }
}

