/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.PersonUtil;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ClientRelativeDateUtil;
import de.justsoftware.onx.common.presentation.client.IgnoreResultAsyncCallback;
import de.justsoftware.onx.common.presentation.client.ui.JucoSafeHtmlTemplates;
import de.justsoftware.onx.common.presentation.client.ui.RelativeDateLabel;
import de.justsoftware.onx.common.shared.model.BadgeField;
import de.justsoftware.onx.common.shared.model.Teaser;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.presentation.client.EntityUtils;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.SearchableId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.searchnew.presentation.client.SearchTrackingInfo;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchResultBadgeView;
import de.justsoftware.onx.searchnew.shared.model.CompoundIdStringUtil;
import de.justsoftware.onx.searchnew.shared.model.LearnToRankToggleValue;
import de.justsoftware.onx.searchnew.shared.model.SearchTrackingAction;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public class BaseSearchResultBadgePresenter
implements SearchResultBadgeView.Presenter {
    protected static final String NEWS_POSTS = "/news/posts/";
    protected static final String NEWS_CHANNEL = "/news/channel/";
    protected final SearchResultBadgeView _view;
    protected final ClientFactory _clientFactory;
    protected final SearchTrackingInfo _searchTrackingInfo;
    protected final SearchableId _searchResultId;

    public BaseSearchResultBadgePresenter(ClientFactory clientFactory, boolean withContextSwitch, SearchableId searchResultId, @Nullable SearchTrackingInfo searchTrackingInfo, @Nullable String additionalOverlayStyleName) {
        this._clientFactory = clientFactory;
        this._searchTrackingInfo = searchTrackingInfo;
        this._searchResultId = searchResultId;
        this._view = this._clientFactory.searchFactory().getSearchResultBadgeView((SearchResultBadgeView.Presenter)this, withContextSwitch, additionalOverlayStyleName);
    }

    public SearchResultBadgeView getView() {
        return this._view;
    }

    @Nonnull
    protected static List<String> getParentsHtmlLinks(@Nullable PersonTeaserModel linkedProfile, @Nullable List<EntityInfo> linkedEntities) {
        ImmutableList.Builder parentsLinks = ImmutableList.builder();
        parentsLinks.addAll((Iterable)EntityUtils.createEntityNamesOrLabelsHtml(linkedEntities));
        if (linkedProfile != null) {
            parentsLinks.add((Object)PersonUtil.profileLinkAsHtml((PersonTeaserModel)linkedProfile));
        }
        return FluentIterable.from((Iterable)parentsLinks.build()).transform(JucoSafeHtmlTemplates.SAFE_HTML_TO_STRING).toList();
    }

    @Nonnull
    private static String getRelativeDateString(@Nullable Date date) {
        return date == null ? "" : ClientRelativeDateUtil.INSTANCE.getRelativeTime(date);
    }

    protected void setParent(@Nullable PersonTeaserModel linkedProfile, @Nullable List<EntityInfo> linkedEntities) {
        this._view.setParentEnabled(true);
        List parentsHtmlLinks = BaseSearchResultBadgePresenter.getParentsHtmlLinks((PersonTeaserModel)linkedProfile, linkedEntities);
        if (!CollectionUtil.isEmpty((Iterable)parentsHtmlLinks)) {
            HTML parents = new HTML(Joiner.on((String)", ").join((Iterable)parentsHtmlLinks));
            parents.setTitle(Joiner.on((String)", ").join((Iterable)BaseSearchResultBadgePresenter.getParentsNames((PersonTeaserModel)linkedProfile, linkedEntities)));
            this._view.setParentWidget((Widget)parents);
        }
    }

    private static ImmutableList<String> getParentsNames(@Nullable PersonTeaserModel linkedProfile, @Nullable List<EntityInfo> linkedEntities) {
        ImmutableList.Builder parentNames = ImmutableList.builder();
        if (linkedProfile != null) {
            parentNames.add((Object)PersonUtil.fullName((PersonTeaserModel)linkedProfile));
        }
        if (linkedEntities != null && !CollectionUtil.isEmpty(linkedEntities)) {
            parentNames.addAll((Iterable)FluentIterable.from(linkedEntities).transform(Teaser.GET_NAME).filter(Predicates.notNull()).toList());
        }
        return parentNames.build();
    }

    protected void setLastChangeDate(@Nullable Date modifyDate) {
        this._view.setLastChangeWidget((Widget)new Label(BaseSearchResultBadgePresenter.getRelativeDateString((Date)modifyDate)));
    }

    protected void addPublicationDate(boolean show, @Nullable Date publicationDate) {
        if (show && publicationDate != null) {
            this._view.addDetails(I18nMediator.SEARCH.publicationDate(), (Widget)new RelativeDateLabel(publicationDate));
        }
    }

    @Nonnull
    protected static HashMap<String, BadgeField> mapBadgeFieldByName(@Nullable Collection<BadgeField> badgeFields) {
        if (badgeFields == null) {
            return new HashMap<String, BadgeField>();
        }
        HashMap<String, BadgeField> result = new HashMap<String, BadgeField>(badgeFields.size());
        result.putAll((Map<String, BadgeField>)Maps.uniqueIndex(badgeFields, (Function)BadgeField.TO_NAME));
        return result;
    }

    public void onSelectResult() {
        this.track(SearchTrackingAction.USER_OPEN_RESULT);
    }

    private void track(SearchTrackingAction action) {
        if (this._clientFactory.getHostPropertiesBean().getLearnToRankEnabled() != LearnToRankToggleValue.DISABLED) {
            this._clientFactory.searchFactory().controller().trackFeedback(this._searchTrackingInfo.getSearchId(), CompoundIdStringUtil.getCompoundIdSearchStringFromSearchableId((SearchableId)this._searchResultId), action, this._searchTrackingInfo.getSearchParameters().getSortType(), (AsyncCallback)IgnoreResultAsyncCallback.newCallback());
        }
    }
}

