/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.presentation.client.ui.component;

import com.freiheit.toro.client.mediator.Callback;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.event.dom.client.ClickHandler;
import de.justsoftware.onx.common.presentation.client.ui.ConfirmDialogOpeningClickHandler;
import de.justsoftware.onx.common.presentation.client.ui.DelegatingClickHandler;
import de.justsoftware.onx.person.presentation.client.ui.component.ProfileOptionsView;
import de.justsoftware.onx.person.shared.i18n.ProfileConstants;
import de.justsoftware.onx.person.shared.i18n.ProfileMessages;

public abstract class AbstractProfileOptionsView
implements ProfileOptionsView {
    private static final ProfileConstants PROFILE = I18nMediator.PROFILE;
    private static final ProfileMessages PROFILE_MSG = I18nMediator.PROFILE_MSG;

    public void addPersonEdit(String historyToken, boolean extended) {
        this.addLink(IconType.COG, PROFILE.editProfile(), historyToken, extended);
    }

    public void addAdminDeleteWithoutPassword(Callback selected, String fullName, boolean extended) {
        this.addLink(IconType.TRASH, PROFILE.deletePerson(), (ClickHandler)new ConfirmDialogOpeningClickHandler(PROFILE_MSG.deleteAccountQuestion(fullName), selected), extended);
    }

    public void addAdminBlockProfile(Callback selected, boolean personIsBlocked, boolean extended) {
        String linkText = personIsBlocked ? PROFILE.unblockPerson() : PROFILE.blockPerson();
        this.addLink(IconType.BAN_CIRCLE, linkText, (ClickHandler)new DelegatingClickHandler(selected), extended);
    }

    public void addAdminActivateProfile(Callback selected, boolean personIsActive) {
        String linkText = personIsActive ? PROFILE.deactivatePerson() : PROFILE.activatePerson();
        this.addLink(IconType.BAN_CIRCLE, linkText, (ClickHandler)new DelegatingClickHandler(selected), true);
    }

    public void addRemoveContact(Callback selected, boolean extended) {
        this.addLink(IconType.MINUS_SIGN, PROFILE.removeContact(), (ClickHandler)new ConfirmDialogOpeningClickHandler(PROFILE.reallyRemoveContact(), selected), extended);
    }

    public void addRemoveInvitation(Callback selected, boolean extended) {
        this.addLink(IconType.MINUS_SIGN, PROFILE.removeContactRequest(), (ClickHandler)new DelegatingClickHandler(selected), PROFILE.contactRequestSend(), extended);
    }

    public void addAcceptInvitation(Callback selected, boolean extended) {
        this.addLink(null, PROFILE.acceptInvitation(), (ClickHandler)new DelegatingClickHandler(selected), PROFILE.invitationAccepted(), extended);
    }

    public void addDeclineInvitation(Callback selected, boolean extended) {
        this.addLink(null, PROFILE.declineInvitation(), (ClickHandler)new DelegatingClickHandler(selected), PROFILE.invitationDeclined(), extended);
    }

    public void addContact(Callback selected, boolean extended) {
        this.addLink(IconType.USER, PROFILE.inviteAsContact(), (ClickHandler)new DelegatingClickHandler(selected), extended);
    }

    public void addEditAccount(String token, boolean extended) {
        this.addLink(IconType.WRENCH, PROFILE.editAccountSettings(), token, extended);
    }

    public void addStartChat(Callback selected, boolean extended) {
        this.addLink(IconType.COMMENTS, PROFILE.startChat(), (ClickHandler)new DelegatingClickHandler(selected), extended);
    }
}

