/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.presentation.client;

import com.freiheit.toro.account.presentation.ui.LoginManagerImpl;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.HostPropertiesBean;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.person.presentation.client.AccountSettingsPresenter;
import de.justsoftware.onx.person.presentation.client.PersonMediator;
import de.justsoftware.onx.person.presentation.client.SectionExpandClickHandler;
import de.justsoftware.onx.person.presentation.client.SectionHasChangesHandler;
import de.justsoftware.onx.person.presentation.client.UserDataSettingsPresenter;
import de.justsoftware.onx.person.presentation.client.ui.AccountSettingsSection;
import de.justsoftware.onx.person.presentation.client.ui.AccountSettingsTabViewImpl;
import de.justsoftware.onx.person.presentation.client.ui.EmailSettingsViewImpl;
import de.justsoftware.onx.person.presentation.client.ui.PasswordSettingsViewImpl;
import de.justsoftware.onx.person.shared.i18n.ProfileConstants;
import de.justsoftware.onx.person.shared.model.DBAccountSettings;
import de.justsoftware.onx.person.shared.util.PersonUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class UserDataSettingsPresenter
implements AccountSettingsPresenter.SettingsPresenter {
    private static final BasicConstants BASIC_CONSTANTS = I18nMediator.BASIC_CONSTANTS;
    private static final ProfileConstants PROFILE_CONSTANTS = I18nMediator.PROFILE;
    private final HostPropertiesBean _properties = HostPropertiesMediator.getHostPropertiesBean();
    private final ImmutableSet<String> _hiddenFields = this._properties.getHiddenPersonFields();
    private final String[] _additionalWildCards = new String[]{"person.*"};
    private final Collection<String> _restrictedFields = this._properties.getModificationRestrictedPersonFields();
    private final AccountSettingsPresenter.AccountSettingsTabView _view;
    private DBAccountSettings _accountSettings;
    private final PersonId _personId;
    private final boolean _ownProfile;

    public UserDataSettingsPresenter(@Nonnull PersonId personId, @Nonnull HasWidgets container) {
        this._personId = personId;
        this._ownProfile = this._personId.equals((Object)LoginManagerImpl.getInstance().getPersonId());
        this._view = new AccountSettingsTabViewImpl();
        container.add((Widget)this._view);
        this.updateModels();
    }

    private void initGUI() {
        this._view.removeAllSections();
        this.addEmailSection();
        this.addPasswordSection();
        for (AccountSettingsSection section : this._view.getSections()) {
            section.addExpandClickHandler((ClickHandler)new SectionExpandClickHandler(section, this._view.getSections()));
            section.setCancelClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void addPasswordSection() {
        boolean passwordVisible = AccountSettingsPresenter.isPasswordSectionVisible();
        if (passwordVisible) {
            this._view.addSection(BASIC_CONSTANTS.password(), (AccountSettingsSection.FillSectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void fillPasswordSection(AccountSettingsSection passwordSection) {
        boolean passwordEnabled;
        PasswordSettingsViewImpl view = new PasswordSettingsViewImpl();
        view.setOldPasswordVisible(this._ownProfile);
        boolean bl = passwordEnabled = !PersonUtil.isRestricted((String)"person.password", (Collection)this._restrictedFields, (String[])this._additionalWildCards);
        if (passwordEnabled) {
            view.setPasswordValidationVisible(false);
            view.addNewPasswordFocusHandler((FocusHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        view.addNewPasswordKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        view.enablePassword(passwordEnabled);
        view.addSectionHasChangesHandler((ValueChangeHandler)new SectionHasChangesHandler(passwordSection));
        view.setPasswordValidationVisible(passwordEnabled);
        passwordSection.setContent((IsWidget)view);
        passwordSection.setSaveClickHandler((ClickHandler)new PasswordSaveHandler(this, (PasswordSettingsView)view, passwordSection));
    }

    private void addEmailSection() {
        boolean emailVisible = AccountSettingsPresenter.isEmailSectionVisible();
        if (emailVisible) {
            this._view.addSection(PROFILE_CONSTANTS.email(), (AccountSettingsSection.FillSectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void fillEmailSection(@Nonnull AccountSettingsSection emailSection) {
        EmailSettingsViewImpl view = new EmailSettingsViewImpl();
        view.setCurrentMail(this._accountSettings.getEmail());
        boolean newEmailVisible = !PersonUtil.isHidden((String)"person.new.email", (Set)this._hiddenFields, (String[])this._additionalWildCards);
        view.setNewMailVisible(newEmailVisible);
        view.setPasswordVisible(newEmailVisible && this._ownProfile);
        if (newEmailVisible) {
            view.addSectionHasChangesHandler((ValueChangeHandler)new SectionHasChangesHandler(emailSection));
            view.setNewMailEnabled(!PersonUtil.isRestricted((String)"person.new.email", (Collection)this._restrictedFields, (String[])this._additionalWildCards));
            emailSection.setSaveClickHandler((ClickHandler)new EMailSaveHandler(this, emailSection, (EmailSettingsView)view));
        } else {
            emailSection.enableSaveButton(false);
        }
        emailSection.setContent((IsWidget)view);
    }

    private void updateModels() {
        this._view.removeAllSections();
        PersonMediator.getInstance().getAccountSettings(this._personId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<AccountSettingsSection> getSections() {
        return this._view.getSections();
    }
}

