/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.multiwiki.presentation.client;

import com.freiheit.toro.client.event.GlobalEventManager;
import com.freiheit.toro.client.mediator.HistoryManager;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.presentation.client.ui.FullscreenView;
import de.justsoftware.onx.common.presentation.client.ui.PopupHelper;
import de.justsoftware.onx.common.presentation.client.ui.editor.EditorClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.impl.FullscreenViewImpl;
import de.justsoftware.onx.common.presentation.client.ui.overlaynotifications.OverlayNotificationListPresenter;
import de.justsoftware.onx.common.shared.model.AuthorityModel;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.container.presentation.client.EntityClientFactory;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.logging.client.ClientLogger;
import de.justsoftware.onx.multiwiki.presentation.client.MultiWikiComponentFactory;
import de.justsoftware.onx.multiwiki.presentation.client.ui.presenters.MultiWikiEditorPresenter;
import de.justsoftware.onx.multiwiki.presentation.client.ui.presenters.MultiWikiFullscreenPresenter;
import de.justsoftware.onx.multiwiki.presentation.client.ui.presenters.MultiWikiPresenter;
import de.justsoftware.onx.multiwiki.presentation.client.ui.presenters.MultiWikiSectionHeadlinePresenter;
import de.justsoftware.onx.multiwiki.presentation.client.ui.presenters.MultiWikiSectionPresenter;
import de.justsoftware.onx.multiwiki.presentation.client.ui.presenters.MultiWikiSectionVisibilitiesPresenter;
import de.justsoftware.onx.multiwiki.presentation.client.ui.presenters.MultiWikiTOCPresenter;
import de.justsoftware.onx.multiwiki.presentation.client.ui.presenters.MultiWikiViewAsRolePresenter;
import de.justsoftware.onx.multiwiki.presentation.client.ui.views.MultiWikiHeadlinesTOCView;
import de.justsoftware.onx.multiwiki.presentation.client.ui.views.MultiWikiSectionView;
import de.justsoftware.onx.multiwiki.presentation.client.ui.views.MultiWikiSectionViewImpl;
import de.justsoftware.onx.multiwiki.presentation.client.ui.views.MultiWikiSectionsTOCView;
import de.justsoftware.onx.multiwiki.presentation.client.ui.views.MultiWikiTOCView;
import de.justsoftware.onx.multiwiki.presentation.client.ui.views.MultiWikiView;
import de.justsoftware.onx.multiwiki.presentation.client.ui.views.MultiWikiViewAsRoleView;
import de.justsoftware.onx.multiwiki.presentation.client.ui.views.MultiWikiViewAsRoleViewImpl;
import de.justsoftware.onx.multiwiki.presentation.client.ui.views.MultiWikiViewImpl;
import de.justsoftware.onx.multiwiki.presentation.shared.MultiWikiControllerAsync;
import de.justsoftware.onx.multiwiki.shared.i18n.MultiWikiMessages;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiClientModel;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiId;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiSectionClientModel;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiTocType;
import de.justsoftware.onx.person.presentation.shared.PersonSettingsControllerAsync;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MultiWikiComponentFactoryImpl
implements MultiWikiComponentFactory {
    private final GlobalEventManager _globalEventManager;
    private final EditorClientFactory _editorFactory;
    private final EntityClientFactory _entityClientFactory;
    private final MultiWikiControllerAsync _controller;
    private final PopupHelper _popupHelper;
    private final EventManager _eventManager;
    private final PersonSettingsControllerAsync _personSettingsController;
    private final ClientLogger _clientLogger;
    private final OverlayNotificationListPresenter _overlayNotificationsListPresenter;
    private final HistoryManager _historyManager;

    public MultiWikiComponentFactoryImpl(EditorClientFactory editorFactory, EntityClientFactory entityClientFactory, MultiWikiControllerAsync controller, PopupHelper popupHelper, EventManager eventManager, PersonSettingsControllerAsync personSettingsController, ClientLogger clientLogger, OverlayNotificationListPresenter overlayNotificationsListPresenter, HistoryManager historyManager, GlobalEventManager globalEventManager) {
        this._editorFactory = editorFactory;
        this._entityClientFactory = entityClientFactory;
        this._controller = controller;
        this._popupHelper = popupHelper;
        this._eventManager = eventManager;
        this._personSettingsController = personSettingsController;
        this._clientLogger = clientLogger;
        this._overlayNotificationsListPresenter = overlayNotificationsListPresenter;
        this._historyManager = historyManager;
        this._globalEventManager = globalEventManager;
    }

    public MultiWikiPresenter multiWikiPresenter(MultiWikiClientModel model, EntityId parentId, EntityType type) {
        ClientEntityConfig clientEntityConfig = HostPropertiesMediator.getClientEntityConfig((EntityType)type);
        return new MultiWikiPresenter((MultiWikiComponentFactory)this, this._entityClientFactory.entityConstants(type), this._controller, this._editorFactory, model, parentId, HostPropertiesMediator.getHostPropertiesBean().getEditorToolbar(), clientEntityConfig.isEnableBrowserSearch(), this._historyManager, GlobalEventManager.getInstance(), I18nMediator.MULTI_WIKI);
    }

    public MultiWikiView multiWikiView(MultiWikiView.Presenter presenter, boolean browserSearchEnabled) {
        return new MultiWikiViewImpl(presenter, browserSearchEnabled);
    }

    public MultiWikiViewAsRolePresenter viewAsRolePresenter(MultiWikiViewAsRolePresenter.ViewAsRoleChangeHandler changeHandler) {
        return new MultiWikiViewAsRolePresenter((MultiWikiComponentFactory)this, changeHandler);
    }

    public MultiWikiViewAsRoleView viewAsRoleView(MultiWikiViewAsRoleView.Presenter presenter) {
        return new MultiWikiViewAsRoleViewImpl(presenter);
    }

    public MultiWikiTOCPresenter tocPresenter(MultiWikiTOCPresenter.ScrollHandler scrollHandler, MultiWikiTocType type) {
        return new MultiWikiTOCPresenter(scrollHandler, (MultiWikiComponentFactory)this, type);
    }

    public MultiWikiTOCView tocSectionsView(MultiWikiTOCView.Presenter presenter) {
        return new MultiWikiSectionsTOCView(presenter, I18nMediator.MULTI_WIKI);
    }

    public MultiWikiTOCView tocHeadlinesView(MultiWikiTOCView.Presenter presenter) {
        return new MultiWikiHeadlinesTOCView(presenter);
    }

    public MultiWikiSectionPresenter sectionPresenter(MultiWikiSectionClientModel section, MultiWikiId multiWikiId, String toolbar, MultiWikiEditorPresenter.EditHandler editHandler, boolean mayEdit, boolean folded, ImmutableList<AuthorityModel> availableRoles) {
        return new MultiWikiSectionPresenter((MultiWikiComponentFactory)this, multiWikiId, this._editorFactory, section, toolbar, editHandler, mayEdit, folded, availableRoles);
    }

    public MultiWikiSectionView sectionView(MultiWikiSectionView.Presenter presenter) {
        return new MultiWikiSectionViewImpl(presenter);
    }

    public MultiWikiEditorPresenter editorPresenter(EditorClientFactory editorFactory, GlobalId parentId, String content, String editorToolbar, MultiWikiEditorPresenter.EditHandler editHandler, boolean editable) {
        return new MultiWikiEditorPresenter(editorFactory, parentId, content, editorToolbar, editHandler, editable);
    }

    public MultiWikiSectionHeadlinePresenter sectionHeadlinePresenter(EditorClientFactory editorFactory, String initialTitle, boolean mayEdit, MultiWikiEditorPresenter.EditHandler editHandler) {
        return new MultiWikiSectionHeadlinePresenter(editorFactory, initialTitle, mayEdit, editHandler);
    }

    public MultiWikiSectionVisibilitiesPresenter sectionVisibilityPresenter(EditorClientFactory editorFactory, ImmutableList<String> selectedRoles, boolean mayEdit, MultiWikiEditorPresenter.EditHandler editHandler, ImmutableList<AuthorityModel> availableAuthorities) {
        return new MultiWikiSectionVisibilitiesPresenter(editorFactory, selectedRoles, mayEdit, editHandler, HostPropertiesMediator.getHostPropertiesBean().getPersonRolesTranslation(), I18nMediator.BASIC_MESSAGES, I18nMediator.BASIC_CONSTANTS, availableAuthorities);
    }

    public MultiWikiFullscreenPresenter multiWikiFullscreenPresenter(FullscreenView.OnFullscreenClosedCallback callback, MultiWikiClientModel wiki, EntityId parentId, EntityConstants contants, String toolbar) {
        return new MultiWikiFullscreenPresenter(callback, (MultiWikiComponentFactory)this, contants, this._controller, this._editorFactory, wiki, parentId, toolbar, false, this._historyManager, this._globalEventManager, I18nMediator.MULTI_WIKI);
    }

    public FullscreenView multiWikiFullscreenView(FullscreenView.Presenter presenter) {
        return new FullscreenViewImpl(presenter);
    }

    public PopupHelper popupHelper() {
        return this._popupHelper;
    }

    public EventManager eventManager() {
        return this._eventManager;
    }

    public PersonSettingsControllerAsync personSettingsController() {
        return this._personSettingsController;
    }

    public ClientLogger clientLogger() {
        return this._clientLogger;
    }

    public OverlayNotificationListPresenter overlayNotificationListPresenter() {
        return this._overlayNotificationsListPresenter;
    }

    public MultiWikiMessages multiWikiMessages() {
        return I18nMediator.MULTI_WIKI;
    }
}

