/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.presentation.server.impl;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import de.justsoftware.common.clock.Clock;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.server.util.FileUtils;
import de.justsoftware.onx.mail.business.ImportResultMailService;
import de.justsoftware.onx.migration.business.CSVExportGeneratedAccountsImportPostProcessorConfiguration;
import de.justsoftware.onx.migration.business.CSVImportDataProvider;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.model.ImportStatistics;
import de.justsoftware.onx.migration.shared.i18n.ImportMessages;
import de.justsoftware.onx.migration.shared.model.ImportResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.function.BiConsumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.universalchardet.UniversalDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@ParametersAreNonnullByDefault
public class CSVImportUploadController {
    private static final Logger LOG = LoggerFactory.getLogger(CSVImportUploadController.class);
    private static final String CSV_EXTENSION = "csv";
    @Autowired
    private SessionAuthorizationContextProvider _sessionAuthorizationContextProvider;
    @Qualifier(value="csvPersonImportDataProvider")
    @Autowired(required=false)
    private CSVImportDataProvider _csvImportDataProvider;
    @Autowired(required=false)
    @Qualifier(value="personImportService")
    private PersonImportService _personImportService;
    @Autowired
    private Clock _clock;
    @Autowired
    private I18nService _i18nService;
    @Autowired(required=false)
    private CSVExportGeneratedAccountsImportPostProcessorConfiguration _csvGeneratedAccountsConfiguration;
    @Autowired
    private ImportResultMailService _mailService;

    @Deprecated
    public CSVImportUploadController() {
    }

    public CSVImportUploadController(@Nullable CSVImportDataProvider csvImportDataProvider, @Nullable CSVExportGeneratedAccountsImportPostProcessorConfiguration csvGeneratedAccountsConfiguration, @Nullable PersonImportService personImportService, SessionAuthorizationContextProvider sessionAuthorizationContextProvider, Clock clock, I18nService i18nService, ImportResultMailService mailService) {
        this._csvImportDataProvider = csvImportDataProvider;
        this._csvGeneratedAccountsConfiguration = csvGeneratedAccountsConfiguration;
        this._sessionAuthorizationContextProvider = sessionAuthorizationContextProvider;
        this._personImportService = personImportService;
        this._clock = clock;
        this._i18nService = i18nService;
        this._mailService = mailService;
    }

    @RequestMapping(value={"/import/csv-upload"}, method={RequestMethod.POST})
    public void uploadCSV(MultipartHttpServletRequest request, HttpServletResponse response) {
        AuthorizationContext authorizationContext = this._sessionAuthorizationContextProvider.getAuthorizationContextForCurrentUser((HttpServletRequest)request);
        ImportMessages translations = (ImportMessages)this._i18nService.createProxy(ImportMessages.class, authorizationContext.getLocale());
        if (!authorizationContext.may((Action)StaticAction.ADMIN_IMPORT_EXTERNAL_PERSONS)) {
            CSVImportUploadController.sendImportError((HttpServletResponse)response, (String)translations.noPermissionToUploadImportFile());
            return;
        }
        if (!this.importConfigurationValid(response, translations)) {
            return;
        }
        ImportStatistics statistics = new ImportStatistics(this._clock.now());
        Iterator fileNames = request.getFileNames();
        while (fileNames.hasNext()) {
            try {
                MultipartFile multipart = request.getFile((String)fileNames.next());
                statistics = statistics.merge(this.handleFileUploadAndImport(response, translations, multipart));
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                CSVImportUploadController.sendImportError((HttpServletResponse)response, (String)translations.couldNotSaveFile());
                return;
            }
        }
        this._mailService.sendImportResult(authorizationContext.getUserId(), statistics);
        ImportResult result = statistics.toImportResult();
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("status", (Object)"ok");
            jsonObject.put("importResult", (Object)this.importResultToJson(result));
            CSVImportUploadController.sendMessage((HttpServletResponse)response, (String)jsonObject.toString(), (int)200);
        }
        catch (JSONException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            CSVImportUploadController.sendImportError((HttpServletResponse)response, (String)e.getMessage());
        }
    }

    private boolean importConfigurationValid(HttpServletResponse response, ImportMessages translations) {
        if (this._csvImportDataProvider == null) {
            CSVImportUploadController.sendImportError((HttpServletResponse)response, (String)translations.csvDataProviderNotConfigured());
            return false;
        }
        if (this._personImportService == null) {
            CSVImportUploadController.sendImportError((HttpServletResponse)response, (String)translations.personImportServiceNotConfigured());
            return false;
        }
        if (!this._personImportService.isEnabled()) {
            CSVImportUploadController.sendImportError((HttpServletResponse)response, (String)translations.personImportServiceNotEnabled());
            return false;
        }
        return true;
    }

    @Nonnull
    private JSONObject importResultToJson(ImportResult importResult) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("processedCount", importResult.getProcessedCount());
        jsonObject.put("insertedCount", importResult.getInsertedCount());
        jsonObject.put("updatedCount", importResult.getUpdatedCount());
        jsonObject.put("failedCount", importResult.getFailedCount());
        jsonObject.put("skippedCount", importResult.getSkippedCount());
        jsonObject.put("startDate", importResult.getStartDate().getTime());
        jsonObject.put("failedImports", importResult.getFailedImports());
        jsonObject.put("successfulImports", importResult.getSuccessfulImports());
        DateWithoutTimezone endDate = importResult.getEndDate();
        if (endDate != null) {
            jsonObject.put("endDate", endDate.getTime());
        }
        return jsonObject;
    }

    @CheckForNull
    private ImportStatistics handleFileUploadAndImport(HttpServletResponse response, ImportMessages translations, MultipartFile multipart) throws IOException {
        String errorMessage = this.checkFile(multipart, translations);
        if (errorMessage != null) {
            CSVImportUploadController.sendImportError((HttpServletResponse)response, (String)errorMessage);
            return null;
        }
        String fileName = this._csvImportDataProvider.getCsvFilename();
        FileUtils.moveMultipartFile((MultipartFile)multipart, (File)new File(fileName), (boolean)false, (Clock)this._clock);
        try {
            return this._personImportService.importPersons();
        }
        catch (ImportException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            CSVImportUploadController.sendImportError((HttpServletResponse)response, (String)e.getMessage());
            return null;
        }
    }

    @RequestMapping(value={"/import/csv-download"}, method={RequestMethod.GET}, produces={"application/octet-stream"})
    @ResponseBody
    @CheckForNull
    public FileSystemResource downloadCSV(HttpServletRequest request, HttpServletResponse response) {
        AuthorizationContext authorizationContext = this._sessionAuthorizationContextProvider.getAuthorizationContextForCurrentUser(request);
        ImportMessages translations = (ImportMessages)this._i18nService.createProxy(ImportMessages.class, authorizationContext.getLocale());
        if (!authorizationContext.may((Action)StaticAction.ADMIN_IMPORT_EXTERNAL_PERSONS)) {
            CSVImportUploadController.sendImportError((HttpServletResponse)response, (String)translations.noPermissionToDownloadImportFile());
            return null;
        }
        if (this._csvImportDataProvider == null) {
            CSVImportUploadController.sendImportError((HttpServletResponse)response, (String)translations.csvDataProviderNotConfigured());
            return null;
        }
        String fileName = this._csvImportDataProvider.getCsvFilename();
        FileSystemResource res = new FileSystemResource(fileName);
        if (!res.exists()) {
            CSVImportUploadController.sendImportError((HttpServletResponse)response, (String)translations.noUploadedFile());
            return null;
        }
        CSVImportUploadController.setContentDispositionAttachment((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1), (String)res.getFilename());
        return res;
    }

    @RequestMapping(value={"/import/csv-accounts-download"}, method={RequestMethod.GET}, produces={"application/octet-stream"})
    @ResponseBody
    @CheckForNull
    public Resource downloadCreatedAccountsCSV(HttpServletRequest request, HttpServletResponse response) {
        AuthorizationContext authCtx = this._sessionAuthorizationContextProvider.getAuthorizationContextForCurrentUser(request);
        ImportMessages translations = (ImportMessages)this._i18nService.createProxy(ImportMessages.class, authCtx.getLocale());
        if (!authCtx.may((Action)StaticAction.ADMIN_IMPORT_EXTERNAL_PERSONS)) {
            CSVImportUploadController.sendImportError((HttpServletResponse)response, (String)translations.noPermissionToDownloadAccountExportFile());
            return null;
        }
        if (this._csvGeneratedAccountsConfiguration == null) {
            CSVImportUploadController.sendImportError((HttpServletResponse)response, (String)translations.csvAccountExportNotConfigured());
            return null;
        }
        FileSystemResource res = new FileSystemResource(this._csvGeneratedAccountsConfiguration.getOutputFilename());
        CSVImportUploadController.setContentDispositionAttachment((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1), (String)res.getFilename());
        return res.exists() ? res : new /* Unavailable Anonymous Inner Class!! */;
    }

    @VisibleForTesting
    static boolean isCharsetSupported(MultipartFile multipart) throws IOException {
        String s = UniversalDetector.detectCharset((InputStream)multipart.getInputStream());
        if (s == null) {
            return true;
        }
        return Charset.isSupported(s);
    }

    @CheckForNull
    private String checkFile(MultipartFile multipart, ImportMessages translations) throws IOException {
        if (!FilenameUtils.getExtension((String)multipart.getOriginalFilename()).equals("csv")) {
            return translations.fileMustBeCSV();
        }
        if (!CSVImportUploadController.isCharsetSupported((MultipartFile)multipart)) {
            return translations.fileMustBeUTF8Encoded();
        }
        return null;
    }

    private static void sendImportError(HttpServletResponse response, String errorMessage) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("status", (Object)"error");
            jsonObject.put("error", (Object)errorMessage);
            CSVImportUploadController.sendMessage((HttpServletResponse)response, (String)jsonObject.toString(), (int)400);
        }
        catch (JSONException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendMessage(HttpServletResponse response, String message, int responseCode) {
        response.setStatus(responseCode);
        response.setContentType("text/html; charset=utf-8");
        try {
            response.getWriter().write(message);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                IOUtils.closeQuietly((Writer)response.getWriter());
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void setContentDispositionAttachment(BiConsumer<String, String> setHeader, String fileName) {
        String result = URLEncoder.encode(fileName, Charsets.UTF_8).replace("+", "%20");
        setHeader.accept("Content-Disposition", "attachment; filename*=UTF-8''" + result);
    }
}

