/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.freiheit.toro.common.shared.util.ImageSize;
import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.github.gwtbootstrap.client.ui.Icon;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.design.client.util.CssClassUtil;
import de.justsoftware.onx.searchnew.shared.model.EntitySuggest;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityLogoCreator {
    public static final EntityLogoCreator DEFAULT = new EntityLogoCreator();
    private final ImageSize _imageSize;

    public EntityLogoCreator(ImageSize imageSize) {
        this._imageSize = imageSize;
    }

    public EntityLogoCreator() {
        this(ImageSize.SMALL);
    }

    @CheckForNull
    public Widget create(EntityInfo entity, boolean inverse) {
        return this.create(entity.getApp(), (EntityType)entity.getType(), entity.getLogo(), inverse);
    }

    @Nonnull
    public Widget createDefaultLogo(CoreApp app, EntityType type, boolean inverse) {
        ClientEntityConfig config = HostPropertiesMediator.getClientEntityConfig((EntityType)type);
        SimplePanel logoPanel = new SimplePanel();
        logoPanel.addStyleName("entity-placeholder-logo");
        String themeStyleName = inverse ? CssClassUtil.getAppBgColorClass((CoreApp)app) : CssClassUtil.getAppColorClass((CoreApp)app);
        logoPanel.addStyleName(themeStyleName);
        if (inverse) {
            logoPanel.addStyleName("inverse");
        }
        logoPanel.addStyleName(CssClassUtil.getStyleForEntityType((EntityType)type));
        logoPanel.addStyleName(CssClassUtil.getWellFormedCssClass((String)this._imageSize.toString()));
        logoPanel.add((Widget)new Icon(config.getIcon()));
        return this.wrap((Widget)logoPanel);
    }

    @CheckForNull
    public Widget create(CoreApp app, EntityType type, @Nullable String logo, boolean inverse) {
        if (!StringUtil.isBlank((String)logo)) {
            return this.wrap((Widget)new Image(ImageUrlUtil.getFullEntityImageUrl((EntityType)type, (ImageSize)this._imageSize, (String)logo)));
        }
        return this.createDefaultLogo(app, type, inverse);
    }

    @CheckForNull
    public Widget create(EntitySuggest entity, boolean inverse) {
        return this.create(entity.getApp(), (EntityType)entity.getType(), entity.getLogo(), inverse);
    }

    @Nonnull
    protected Widget wrapImage(Image image) {
        return this.wrap((Widget)image);
    }

    @Nonnull
    protected Widget wrap(Widget image) {
        return image;
    }
}

