/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.presenter;

import com.freiheit.toro.account.presentation.ui.LoginManagerImpl;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.gwt.jsinterop.Callback;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.presentation.client.ui.InlineFeedbackWidget;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.common.shared.model.ParentEntityConfig;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.Actions;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.presentation.client.EntityMediator;
import de.justsoftware.onx.container.presentation.client.EntityParent;
import de.justsoftware.onx.container.presentation.client.presenter.EntityCreateOrEditBaseDataPresenter;
import de.justsoftware.onx.container.presentation.client.presenter.EntityCreatedCallback;
import de.justsoftware.onx.container.presentation.client.ui.EntityCreateBaseDataView;
import de.justsoftware.onx.container.presentation.client.ui.EntityCreateOrEditBaseDataView;
import de.justsoftware.onx.container.presentation.client.ui.EntityCreateOrEditSubmitButtonsHandler;
import de.justsoftware.onx.container.presentation.client.ui.EntityCreatePopup;
import de.justsoftware.onx.container.presentation.client.ui.EntityCreatePopupHandler;
import de.justsoftware.onx.container.presentation.client.ui.EntityEditDynamicAttributesForm;
import de.justsoftware.onx.container.shared.model.DefaultEntityBaseData;
import de.justsoftware.onx.container.shared.model.EditEntityHistoryTokenTabName;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.db.DBPrivacyType;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityCreateBaseDataPresenter
extends EntityCreateOrEditBaseDataPresenter {
    private final EntityId _defaultParentEntityId = EntityMediator.getInstance().getCurrentEntityId();
    private final EventManager _eventManager;
    private final Date _defaultDate;
    private EntityCreateBaseDataView _baseDataView;
    private final EntityCreatePopup _entityCreatePopup;
    private final Callback<String> _cancelCallback;

    public EntityCreateBaseDataPresenter(EntityType entityType, ClientFactory cf, @Nullable Date defaultDate, EntityCreatePopup entityCreatePopup, EntityCreatedCallback submitCallback, Callback<String> cancelCallback) {
        super(entityType, cf, submitCallback);
        this._eventManager = cf.eventManager();
        this._defaultDate = Dates.clone((Date)defaultDate);
        this._entityCreatePopup = entityCreatePopup;
        this._cancelCallback = cancelCallback;
    }

    public void start(AcceptsOneWidget widget, DefaultEntityBaseData defaultBaseData) {
        if (!LoginManagerImpl.getInstance().may((Action)Actions.entityCreate((EntityType)this._entityType))) {
            widget.setWidget((IsWidget)new InlineFeedbackWidget(I18nMediator.BASIC_CONSTANTS.noPermission(), InlineFeedbackWidget.InlineType.ERROR, true));
            this._entityCreatePopup.setSubmitButtonsEnabled(false);
            return;
        }
        this._baseDataView = this._clientFactory.entityFactory().getEntityCreateBaseDataView(this._entityType, (EntityCreatePopupHandler)this._entityCreatePopup);
        this.configureView((EntityCreateOrEditBaseDataView)this._baseDataView);
        this.initView(defaultBaseData);
        this._dynamicAttributesForm = new EntityEditDynamicAttributesForm(this._entityType, this._clientFactory, true);
        this._baseDataView.getDynamicAttributesPlaceholder().replace((IsWidget)this._dynamicAttributesForm.asWidget());
        this.fillViewFields((EntityCreateOrEditBaseDataView)this._baseDataView, defaultBaseData.getEntity(), this.getPrivacySelections(defaultBaseData), defaultBaseData.getTenantName());
        this._baseDataView.focusName();
        widget.setWidget((IsWidget)this._baseDataView.asWidget());
    }

    public void show() {
        this._clientFactory.entityFactory().controller().defaultNewEntity(this._defaultParentEntityId, this._entityType, null, this._defaultDate, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initView(DefaultEntityBaseData defaultBaseData) {
        ImmutableList preselectedEntityParents;
        this._baseDataView.setNameEnabled(true);
        ImmutableSet allowedParentEntityTypes = this._baseDataView.initEntityParentAllowedTypes(null, this._entityType, Predicates.alwaysTrue());
        if (ClientStringUtil.hasText((String)defaultBaseData.getEntity().getName())) {
            this._baseDataView.setNameEnabled(false);
        }
        ClientEntityConfig entityConfig = HostPropertiesMediator.getClientEntityConfig((EntityType)this._entityType);
        EntityInfo parentTeaser = defaultBaseData.getParentEntityInfo();
        if (parentTeaser != null && parentTeaser.isVisible()) {
            ParentEntityConfig parentEntityConfig = entityConfig.getParentEntityConfig((EntityType)parentTeaser.getType());
            preselectedEntityParents = ImmutableList.of((Object)new EntityParent(parentTeaser, parentEntityConfig.isInheritsAdminDefaultValue(), parentEntityConfig.isInheritsMemberDefaultValue()));
        } else {
            preselectedEntityParents = ImmutableList.of();
        }
        this._baseDataView.setEntityParents((List)preselectedEntityParents, this.getModifyParentActions(allowedParentEntityTypes));
        if (!entityConfig.getEntityTabOrder().isEmpty() && defaultBaseData.getPermissions().contains((Object)StaticEntityAction.ENTITY_MODIFY_TAB_SETTINGS)) {
            this._baseDataView.showTabSettingsSection();
        }
    }

    @Nonnull
    private ImmutableSet<Action> getModifyParentActions(ImmutableSet<EntityType> allowedParentEntityTypes) {
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        for (EntityType entityType : allowedParentEntityTypes) {
            resultBuilder.add((Object)Actions.entityModifyParent((EntityType)entityType));
        }
        return resultBuilder.build();
    }

    public void submit(@Nullable EditEntityHistoryTokenTabName tabName) {
        this.setSubmitPossible(false);
        this.validate((EntityCreateOrEditBaseDataView)this._baseDataView, (EntityCreateOrEditBaseDataPresenter.ValidationCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    EntityId getEntityId() {
        return null;
    }

    @Nonnull
    private ImmutableSetMultimap<DBPrivacyType, String> getPrivacySelections(DefaultEntityBaseData defaultEntityBaseData) {
        ImmutableSetMultimap.Builder selections = ImmutableSetMultimap.builder();
        selections.putAll((Object)DBPrivacyType.VISIBILITY, (Iterable)defaultEntityBaseData.getVisibility());
        selections.putAll((Object)DBPrivacyType.JOINING, (Iterable)defaultEntityBaseData.getJoinOption());
        selections.putAll((Object)DBPrivacyType.JOIN_REQUEST, (Iterable)defaultEntityBaseData.getJoinRequestOption());
        selections.putAll((Object)DBPrivacyType.MODIFY_TITLE, (Iterable)defaultEntityBaseData.getModifyTitleRoles());
        selections.putAll((Object)DBPrivacyType.ENTITY_EDIT, (Iterable)defaultEntityBaseData.getEntityEditRoles());
        return selections.build();
    }

    protected EntityCreateOrEditSubmitButtonsHandler getSubmitButtonsHandler() {
        return this._entityCreatePopup;
    }
}

