/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.client.validator.Validatable;
import com.freiheit.toro.common.shared.i18n.BasicConstants;
import com.freiheit.toro.common.shared.i18n.BasicMessages;
import com.freiheit.toro.common.shared.model.ValidationException;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.CompositePanelWithValue;
import de.justsoftware.onx.common.presentation.client.ui.InlineCheckBox;
import de.justsoftware.onx.common.presentation.client.ui.TimestampBox;
import de.justsoftware.onx.common.shared.model.TimePeriod;
import java.util.Date;

public class TimePeriodBox
extends CompositePanelWithValue<TimePeriod>
implements Validatable {
    protected static final BasicConstants BASIC = I18nMediator.BASIC;
    protected static final BasicMessages BASIC_MESSAGES = I18nMediator.BASIC_MESSAGES;
    protected final TimestampBox _startTimestamp;
    protected final TimestampBox _endTimestamp;
    protected final Label _tillLabel;
    protected final InlineCheckBox _isWholeDay;
    protected String _fieldName;
    protected boolean _hasTime;
    protected boolean _mandatory;
    protected boolean _enabled = true;
    private Date _lastStart = null;

    public TimePeriodBox() {
        this("");
    }

    public TimePeriodBox(String fieldname) {
        this(fieldname, false);
    }

    public TimePeriodBox(String fieldname, boolean mandatory) {
        super((Panel)new FlowPanel());
        this._fieldName = fieldname;
        this._startTimestamp = new TimestampBox(BASIC.startAt(), mandatory);
        this._endTimestamp = new TimestampBox(BASIC.endAt(), mandatory);
        this._endTimestamp.getTimeBox().setUpdatePopupCommand((TimestampBox.UpdatePopupCommand)new /* Unavailable Anonymous Inner Class!! */);
        this._tillLabel = new Label(BASIC.bis());
        this._isWholeDay = new InlineCheckBox();
        this._isWholeDay.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._mandatory = mandatory;
        this.add((Widget)this._startTimestamp);
        this.add((Widget)this._tillLabel);
        this.add((Widget)this._endTimestamp);
        this.add((Widget)this._isWholeDay);
        this._isWholeDay.setText(I18nMediator.BASIC.wholeDay());
        this.setStyleName("timePeriodBox");
        this._tillLabel.addStyleName("tillLabel");
        this.setHasTime(true);
        this._startTimestamp.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setHasTime(boolean hasTime) {
        this._hasTime = hasTime;
        this._endTimestamp.setHasTime(this._hasTime);
        this._startTimestamp.setHasTime(this._hasTime);
        if (!hasTime) {
            this._isWholeDay.setValue(Boolean.TRUE, true);
        }
        this._isWholeDay.setVisible(this._hasTime);
    }

    public boolean isHasTime() {
        return this._hasTime;
    }

    public void setFieldName(String fieldname) {
        this._fieldName = fieldname;
    }

    public String getFieldName() {
        return this._fieldName;
    }

    public void validate() throws ValidationException {
        TimePeriod timePeriod = this.extractTimePeriod();
        if (this._mandatory && (timePeriod == null || timePeriod.getStartTimestamp() == null || timePeriod.getEndTimestamp() == null)) {
            throw new ValidationException(BASIC_MESSAGES.fillFieldx(this._fieldName));
        }
        if (timePeriod != null && timePeriod.getStartTimestamp() != null && timePeriod.getEndTimestamp() != null && timePeriod.getStartTimestamp().after(timePeriod.getEndTimestamp())) {
            throw new ValidationException(BASIC_MESSAGES.startAfterEndTime(this._fieldName));
        }
    }

    public TimePeriod extractTimePeriod() throws ValidationException {
        try {
            Date start = this._startTimestamp.extractTimestamp();
            Date end = this._endTimestamp.extractTimestamp();
            if (start == null && end == null) {
                return null;
            }
            return new TimePeriod(start, end);
        }
        catch (ValidationException e) {
            throw new ValidationException(BASIC_MESSAGES.fieldInvalidData(this._fieldName));
        }
    }

    public boolean isMandatory() {
        return this._mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this._mandatory = mandatory;
        this._endTimestamp.setMandatory(mandatory);
        this._startTimestamp.setMandatory(mandatory);
    }

    public void setValue(TimePeriod value, boolean fireEvents) {
        if (value == null) {
            this._endTimestamp.setValue(null);
            this._startTimestamp.setValue(null);
            this._lastStart = null;
        } else {
            this._endTimestamp.setValue((Object)value.getEndTimestamp());
            this._startTimestamp.setValue((Object)value.getStartTimestamp());
            this._isWholeDay.setValue(Boolean.valueOf(value.isWholeDay()), true);
            this._lastStart = value.getStartTimestamp();
        }
        super.setValue((Object)value, fireEvents);
    }

    public TimePeriod getValue() {
        try {
            return this.extractTimePeriod();
        }
        catch (ValidationException e) {
            return null;
        }
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
        this._endTimestamp.setEnabled(enabled);
        this._endTimestamp.setTimeEnabled(enabled && !Boolean.TRUE.equals(this._isWholeDay.getValue()));
        this._startTimestamp.setEnabled(enabled);
        this._startTimestamp.setTimeEnabled(enabled && !Boolean.TRUE.equals(this._isWholeDay.getValue()));
        this._isWholeDay.setEnabled(enabled);
    }
}

