/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiFactory;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DeckPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.InPlaceEditLabel;
import de.justsoftware.onx.common.presentation.client.ui.InPlaceEditable;
import de.justsoftware.onx.common.presentation.client.ui.InlineFeedbackWidget;
import de.justsoftware.onx.common.presentation.client.ui.TextBoxWithDescription;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.util.StringUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InPlaceEditLabel
extends Composite
implements HasValueChangeHandlers<String>,
InPlaceEditable {
    private static final InPlaceEditLabelUiBinder UIBINDER = (InPlaceEditLabelUiBinder)GWT.create(InPlaceEditLabelUiBinder.class);
    @UiField
    DeckPanel _deck;
    @UiField
    Label _label;
    @UiField
    TextBoxWithDescription _editBox;
    @UiField
    Label _waitLabel;
    @UiField
    InlineFeedbackWidget _errorMessage;
    private final String _noTextPlaceholder;
    private boolean _asyncEnabled;
    private boolean _forceText = false;
    private boolean _editable = true;
    private String _forceTextErrorMessage = "";
    private String _text;

    public InPlaceEditLabel(@Nullable String text) {
        this(text, null);
    }

    public InPlaceEditLabel(@Nullable String text, @Nullable String placeholder) {
        this(text, placeholder, null);
    }

    public InPlaceEditLabel(@Nullable String text, @Nullable String placeholder, @Nullable String noTextPlaceholder) {
        this.initWidget((Widget)UIBINDER.createAndBindUi((Object)this));
        this._text = text;
        this._noTextPlaceholder = noTextPlaceholder;
        this._editBox.setDescriptionText(placeholder);
        this.setText(text);
        this.setTitle(text);
        this._errorMessage.hide();
        this._deck.showWidget(ViewMode.DECK_INDEX_VIEW.getIdx());
    }

    private void saveText() {
        String value = this._editBox.getText();
        this._errorMessage.hide();
        String error = this.validate(value);
        if (error == null) {
            this._text = value;
            this.setText(value);
            if (this._asyncEnabled) {
                this._waitLabel.setText(value);
                this.setViewMode(ViewMode.DECK_INDEX_WAIT);
            } else {
                this.setViewMode(ViewMode.DECK_INDEX_VIEW);
            }
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)value);
        } else {
            this._errorMessage.setMessage(error);
            this._errorMessage.show(InlineFeedbackWidget.InlineType.ERROR);
        }
    }

    public void cancelEdit() {
        String value = this._text;
        this._errorMessage.hide();
        String error = this.validate(value);
        if (error == null) {
            this._editBox.setText(value);
            this._deck.showWidget(ViewMode.DECK_INDEX_VIEW.getIdx());
        } else {
            this._errorMessage.setMessage(error);
            this._errorMessage.show(InlineFeedbackWidget.InlineType.ERROR);
        }
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> handler) {
        return this.addHandler(handler, ValueChangeEvent.getType());
    }

    public void setAsyncEnabled(boolean asyncEnabled) {
        this._asyncEnabled = asyncEnabled;
    }

    public void setMaxLength(int maxLength) {
        this._editBox.setMaxLength(maxLength);
    }

    public void setText(String text) {
        this._errorMessage.hide();
        if (this._noTextPlaceholder != null && StringUtil.isBlank((String)text)) {
            this._label.setText(this._noTextPlaceholder);
            this._label.addStyleName("no-text");
        } else {
            this._label.setText(text);
            this._label.removeStyleName("no-text");
        }
        this._editBox.setText(text);
    }

    @Nonnull
    public String getText() {
        return this._editBox.getText();
    }

    public void switchToViewMode() {
        this.setViewMode(ViewMode.DECK_INDEX_VIEW);
    }

    public void saveIfInEditMode() {
        if (this._deck.getVisibleWidget() == ViewMode.DECK_INDEX_EDIT.getIdx()) {
            this.saveText();
        }
    }

    public boolean isInViewMode() {
        return this._deck.getVisibleWidget() == ViewMode.DECK_INDEX_VIEW.getIdx();
    }

    public boolean switchToEditMode() {
        if (this._editable) {
            this._deck.showWidget(ViewMode.DECK_INDEX_EDIT.getIdx());
            this._editBox.setText(this._text);
        }
        return this._editable;
    }

    public void setViewMode(ViewMode mode) {
        if (mode.equals((Object)ViewMode.DECK_INDEX_EDIT) && !this._editable) {
            return;
        }
        this._deck.showWidget(mode.getIdx());
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void setViewStyle(String style) {
        this._label.addStyleName(style);
    }

    @UiFactory
    public BasicConstants createBasicConstants() {
        return I18nMediator.BASIC_CONSTANTS;
    }

    protected String validate(String value) {
        return this._forceText && StringUtil.isBlank((String)value) ? this._forceTextErrorMessage : null;
    }

    public boolean isForceText() {
        return this._forceText;
    }

    public void setForceText(boolean forceText) {
        this._forceText = forceText;
    }

    public String getForceTextErrorMessage() {
        return this._forceTextErrorMessage;
    }

    public void setForceTextErrorMessage(String forceTextErrorMessage) {
        this._forceTextErrorMessage = forceTextErrorMessage;
    }
}

