/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.freiheit.toro.util.client.LoggingUtil;
import com.google.common.base.Strings;
import com.google.gwt.core.client.JavaScriptException;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.ui.TextArea;
import de.justsoftware.onx.common.presentation.client.ui.TextAreaView;
import de.justsoftware.onx.common.shared.util.StringUtil;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class GrowingTextArea
extends TextArea
implements TextAreaView {
    protected int _initialHeight = 0;
    private boolean _empty = true;
    private int _maxLength = 0;
    private String _descriptionText;
    private TextAreaView.Presenter _presenter;

    public GrowingTextArea() {
        this(TextAreaView.Presenter.NOP);
    }

    public GrowingTextArea(TextAreaView.Presenter presenter) {
        this._presenter = presenter;
        this.getElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
        this.addStyleName("gwt-TextArea-DescriptionText");
        this.addKeyDownHandler((KeyDownHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addFocusHandler((FocusHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addBlurHandler((BlurHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addKeyPressHandler((KeyPressHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setPresenter(TextAreaView.Presenter presenter) {
        this._presenter = presenter;
    }

    private void onUpdate() {
        String text = super.getText();
        this._empty = StringUtil.isBlank((String)text);
        if (!this._empty && this._maxLength > 0 && text.length() > this._maxLength) {
            super.setText(text.substring(0, this._maxLength));
        }
        this.recalcHeight();
        this._presenter.onUpdate();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.recalcHeight();
        }
    }

    protected void onLoad() {
        super.onLoad();
        try {
            this._initialHeight = this.getOffsetHeight();
            this.recalcHeight();
        }
        catch (JavaScriptException e) {
            LoggingUtil.log((Object)this, (String)("onLoad() error: " + e));
        }
    }

    public void recalcHeight() {
        this.setHeight(this._initialHeight + "px");
        this.setHeight(Math.max(this._initialHeight, this.getElement().getScrollHeight()) + "px");
    }

    public void setText(String text) {
        this._empty = StringUtil.isBlank((String)text);
        super.setText(this._empty ? this._descriptionText : text);
        this.setStyleName("gwt-TextArea-DescriptionText", this._empty);
        if (this.isAttached()) {
            this.recalcHeight();
        }
    }

    public void setVisibleLines(int lines) {
        super.setVisibleLines(lines);
        this.recalcHeight();
    }

    @Nonnull
    public String getText() {
        if (this._empty) {
            return "";
        }
        return Strings.nullToEmpty((String)super.getText());
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public void setMaxLength(int maxLength) {
        this._maxLength = maxLength;
    }

    public String getDescriptionText() {
        return this._descriptionText;
    }

    public void setDescriptionText(String descriptionText) {
        this._descriptionText = descriptionText;
        if (this._empty) {
            super.setText(this._descriptionText);
        }
    }

    static /* synthetic */ void access$001(GrowingTextArea x0, String x1) {
        super.setText(x1);
    }

    static /* synthetic */ void access$101(GrowingTextArea x0, String x1) {
        super.setText(x1);
    }
}

