/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.pager;

import com.github.gwtbootstrap.client.ui.NavLink;
import com.github.gwtbootstrap.client.ui.Pagination;
import com.github.gwtbootstrap.client.ui.base.Style;
import com.github.gwtbootstrap.client.ui.resources.Bootstrap;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HasOneWidget;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.pager.PagerView;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PagerViewImpl
implements PagerView {
    private static final int PAGE_RANGE = 2;
    private static final String NEXT_DEFAULT = ">>";
    private static final String PREV_DEFAULT = "<<";
    final Pagination _pager = new Pagination();
    private final String _nextLabel;
    private final String _prevLabel;
    private PagerView.Presenter _presenter;

    public PagerViewImpl() {
        this(PREV_DEFAULT, NEXT_DEFAULT);
    }

    public PagerViewImpl(@Nonnull String prevLabel, @Nonnull String nextLabel) {
        this._pager.setSize(Pagination.PaginationSize.SMALL);
        this._pager.setStyle((Style)Bootstrap.Pagination.RIGHT);
        this._prevLabel = prevLabel;
        this._nextLabel = nextLabel;
    }

    public void show(HasOneWidget widget, PagerView.Presenter parent, int currentPage, int numberOfPages) {
        this._presenter = parent;
        this.update(currentPage, numberOfPages);
        widget.setWidget((Widget)this._pager);
    }

    public void update(int currentPage, int numberOfPages) {
        this.createPagerButtons(currentPage, numberOfPages, this._pager);
    }

    @Nonnull
    private NavLink createPageButton(int page, boolean enabled, boolean active) {
        NavLink pageLink = this.createPagerLink(String.valueOf(page + 1), enabled, active, (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return pageLink;
    }

    @Nonnull
    private NavLink createPrevButton(boolean enabled) {
        return this.createPagerLink(this._prevLabel, enabled, false, (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Nonnull
    private NavLink createNextButton(boolean enabled) {
        return this.createPagerLink(this._nextLabel, enabled, false, (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Nonnull
    private NavLink createDots() {
        return this.createPagerLink("...", false, false);
    }

    @Nonnull
    private NavLink createPagerLink(@Nonnull String text, boolean enabled, boolean active) {
        return this.createPagerLink(text, enabled, active, null);
    }

    @Nonnull
    private NavLink createPagerLink(@Nonnull String text, boolean enabled, boolean active, @Nullable ClickHandler clickHandler) {
        NavLink pageLink = new NavLink(text);
        pageLink.setStyleName("disabled", !enabled);
        pageLink.setStyleName("active", active);
        if (clickHandler != null) {
            pageLink.addClickHandler(clickHandler);
        }
        return pageLink;
    }

    private void createPagerButtons(int currentPage, int maxPage, @Nonnull Pagination p) {
        int i;
        p.clear();
        if (maxPage <= 1) {
            return;
        }
        int minRange = Math.max(0, currentPage - 2);
        int maxRange = Math.min(maxPage - 1, currentPage + 2 + 1);
        p.add((Widget)this.createPrevButton(currentPage > 0));
        if (minRange > 0) {
            p.add((Widget)this.createPageButton(0, true, false));
            if (minRange > 2) {
                p.add((Widget)this.createDots());
            } else {
                for (i = 1; i < minRange; ++i) {
                    p.add((Widget)this.createPageButton(i, i != currentPage, i == currentPage));
                }
            }
        }
        for (i = minRange; i <= maxRange; ++i) {
            p.add((Widget)this.createPageButton(i, i != currentPage, i == currentPage));
        }
        if (maxRange < maxPage - 1) {
            if (maxRange < maxPage - 2) {
                p.add((Widget)this.createDots());
            }
            p.add((Widget)this.createPageButton(maxPage - 1, true, false));
        }
        p.add((Widget)this.createNextButton(currentPage < maxPage - 1));
    }
}

