/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.pager;

import com.google.gwt.user.client.ui.HasOneWidget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.pager.PagerHandler;
import de.justsoftware.onx.common.presentation.client.pager.PagerView;
import javax.annotation.Nonnull;

public class PagerPresenter
implements PagerView.Presenter {
    private final ClientFactory _clientFactory;
    private final PagerView _view;
    private final PagerHandler _changeHandler;
    private int _currentPage = 0;
    private int _pageSize = 10;
    private int _numberOfPages = 0;

    public PagerPresenter(@Nonnull ClientFactory clientFactory, @Nonnull PagerHandler changeHandler) {
        this._clientFactory = clientFactory;
        this._changeHandler = changeHandler;
        this._view = this._clientFactory.entityVersionFactory().pagerView();
    }

    public void show(HasOneWidget widget, PagerView.PagerModel model) {
        this.init(model);
        this._view.show(widget, (PagerView.Presenter)this, this._currentPage, this._numberOfPages);
    }

    private void updateView() {
        this._view.update(this._currentPage, this._numberOfPages);
    }

    private void init(@Nonnull PagerView.PagerModel pagerModel) {
        this._pageSize = pagerModel.getItemsPerPage();
        this._currentPage = pagerModel.getCurrentPage();
        this._numberOfPages = (pagerModel.getNumberOfItems() + this._pageSize - 1) / this._pageSize;
    }

    public void goToPage(int page) {
        if (page >= 0 && page < this._numberOfPages) {
            this._currentPage = page;
            this._changeHandler.handlePageChange(this._currentPage);
            this.updateView();
        }
    }

    public void nextPage() {
        this.goToPage(this._currentPage + 1);
    }

    public void prevPage() {
        this.goToPage(this._currentPage - 1);
    }
}

