/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.comments.presentation.client.ui;

import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.comments.presentation.client.ui.EditCommentPresenter;
import de.justsoftware.onx.comments.presentation.client.ui.SingleCommentView;
import de.justsoftware.onx.comments.shared.model.GenericComment;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.like.presentation.client.presenter.LikePresenter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class SingleCommentPresenter
implements SingleCommentView.Presenter {
    private GenericComment _comment;
    private final SingleCommentView _commentWidget;
    private final String _customInfoDescription;
    private final ClientFactory _clientFactory;
    private final LikePresenter _likePresenter;

    public SingleCommentPresenter(ClientFactory clientFactory, @Nullable String customInfoDescription) {
        this._clientFactory = clientFactory;
        this._customInfoDescription = customInfoDescription;
        this._commentWidget = this._clientFactory.commentClientFactory().singleComponentView((SingleCommentView.Presenter)this);
        this._likePresenter = new LikePresenter(clientFactory, this._commentWidget.likeView());
    }

    public void onEdit() {
        if (this.isEditAllowed()) {
            new EditCommentPresenter(this._clientFactory, this).show(this._comment);
        }
    }

    public void onDelete() {
        if (this.isDeleteAllowed()) {
            this.onDelete(this._comment);
        }
    }

    protected abstract void onDelete(GenericComment var1);

    public void showComment(GenericComment comment) {
        this._comment = comment;
        String customInfo = comment.getCustomInfo();
        this._commentWidget.setCustomInfoDescription(!StringUtil.isBlank((String)customInfo) && !StringUtil.isBlank((String)this._customInfoDescription) ? this._customInfoDescription + " " + customInfo : null);
        this._commentWidget.setAuthor(comment.getAuthor());
        this._commentWidget.setText(comment.getText(), this._clientFactory.getHostPropertiesBean().getCommentsDisplayedLength());
        this._likePresenter.setId((ItemId)comment.getId());
        this._commentWidget.setPostedAt(comment.getPostedAt());
        this._commentWidget.setEditedAt(comment.getEditedAt());
        this._commentWidget.setEditAllowed(this.isEditAllowed());
        this._commentWidget.setDeleteAllowed(this.isDeleteAllowed());
    }

    private boolean isEditAllowed() {
        return this._comment != null && this._comment.getPermissions().contains((Object)StaticAction.COMMENT_EDIT);
    }

    private boolean isDeleteAllowed() {
        return this._comment != null && this._comment.getPermissions().contains((Object)StaticAction.COMMENT_DELETE);
    }

    @Nonnull
    public IsWidget getView() {
        return this._commentWidget;
    }
}

