/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.calendar.presentation.client.ui;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.calendar.presentation.client.CalendarViewHandler;
import de.justsoftware.onx.calendar.presentation.client.ui.CalendarView;
import de.justsoftware.onx.calendar.presentation.client.ui.CalendarViewInfoPopupPanel;
import de.justsoftware.onx.calendar.presentation.client.ui.MonthViewDayCell;
import de.justsoftware.onx.calendar.presentation.client.ui.MonthViewWholeDayAppointment;
import de.justsoftware.onx.calendar.presentation.client.ui.WholeDayAppointmentWidget;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.EntityBadge;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class MonthViewWholeDayAppointment {
    private final EntityBadge _appointment;
    private final Date _startDate;
    private final List<WholeDayAppointmentWidget> _wholeDayAppointmentWidgets;
    private final CalendarViewHandler _calendarViewHandler;

    public MonthViewWholeDayAppointment(Date startDate, EntityBadge appointment, CalendarViewHandler calendarViewHandler) {
        this._startDate = Dates.clone((Date)startDate);
        this._appointment = appointment;
        this._calendarViewHandler = calendarViewHandler;
        this._wholeDayAppointmentWidgets = new ArrayList();
    }

    public void createWholeDayAppointmentToAbsolutePanel(AbsolutePanel panel, Map<String, MonthViewDayCell> displayedDayWidgets) {
        boolean displayTime;
        int days;
        if (this._startDate == null) {
            return;
        }
        DateWithoutTimezone endAt = this._appointment.getEndAt();
        DateWithoutTimezone startAt = this._appointment.getStartAt();
        if (startAt == null || endAt == null) {
            return;
        }
        Date startDate = this._startDate;
        for (int dayCount = Dates.differenceInDays((Date)endAt, (Date)startDate) + 1; dayCount > 0 && (days = this.createWholeDayAppointmentSingleWeek(startDate, panel, displayedDayWidgets, displayTime = Dates.areOnTheSameDay((Date)startAt, (Date)startDate) && !Dates.isWholeDay((Date)startAt, (Date)endAt), (Date)startAt, (Date)endAt)) > 0; dayCount -= days) {
            startDate = Dates.addDay((Date)startDate, (int)days);
        }
    }

    private int createWholeDayAppointmentSingleWeek(Date startDate, AbsolutePanel panel, Map<String, MonthViewDayCell> displayedDayWidgets, boolean displayTime, @Nonnull Date eventStartDate, @Nonnull Date eventEndDate) {
        Date date = startDate;
        MonthViewDayCell startDayWidget = displayedDayWidgets.get(CalendarView.DATE_KEY_FORMATTER.format(date));
        if (startDayWidget == null) {
            return -1;
        }
        ArrayList<MonthViewDayCell> week = new ArrayList<MonthViewDayCell>(7);
        week.add(startDayWidget);
        int currentRow = startDayWidget.getGridY();
        int width = startDayWidget.getWidth();
        int row = currentRow;
        while (currentRow == row) {
            MonthViewDayCell dayWidget;
            date = Dates.getNextDay((Date)date);
            DateWithoutTimezone endAt = this._appointment.getEndAt();
            if (endAt == null || date.getTime() > endAt.getTime() || (dayWidget = displayedDayWidgets.get(CalendarView.DATE_KEY_FORMATTER.format(date))) == null) break;
            row = dayWidget.getGridY();
            if (currentRow != row) continue;
            week.add(dayWidget);
        }
        int nextFreeSlot = this.getNextFreeSlot(week);
        for (MonthViewDayCell day : week) {
            day.addMutliDayAppointment(this._appointment);
        }
        if (nextFreeSlot <= startDayWidget.getMaxDisplayabeSlot()) {
            int left = startDayWidget.getGridX() * width;
            int top = (startDayWidget.getGridY() - 1) * startDayWidget.getHeight() + 30 + 20 + 5 + (nextFreeSlot - 1) * 21;
            WholeDayAppointmentWidget w = new WholeDayAppointmentWidget(this._appointment, this._calendarViewHandler, width * week.size(), width, displayTime, true, CalendarViewInfoPopupPanel.PopupPriority.PRIMARY, startDate.after(eventStartDate), date.before(eventEndDate));
            w.addMouseOverHandler((MouseOverHandler)new WholeDayAppointmentMouseOverHandler(this));
            w.addMouseOutHandler((MouseOutHandler)new WholeDayAppointmentMouseOutHandler(this));
            this._wholeDayAppointmentWidgets.add(w);
            panel.add((Widget)w, left, top);
            w.setHeight(20);
        }
        return week.size();
    }

    private final int getNextFreeSlot(List<MonthViewDayCell> week) {
        int freeSlot = 0;
        boolean inUse = true;
        block0: while (inUse) {
            ++freeSlot;
            inUse = false;
            for (MonthViewDayCell day : week) {
                if (!day.isSlotUsed(freeSlot)) continue;
                inUse = true;
                continue block0;
            }
        }
        for (MonthViewDayCell day : week) {
            day.useSlot(freeSlot);
        }
        return freeSlot;
    }
}

