/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.business.impl;

import com.freiheit.toro.common.shared.model.NotLoggedInException;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.AuthorizationContextProvider;
import de.justsoftware.onx.authorization.business.FrontendLoginService;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.security.SecurityUtils;
import javax.servlet.http.HttpServletRequest;
import org.gwtwidgets.server.spring.ServletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.LocaleResolver;

@Service(value="sessionAuthorizationContextProvider")
public class SessionAuthorizationContextProviderImpl
implements SessionAuthorizationContextProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionAuthorizationContextProviderImpl.class);
    @Autowired
    private AuthorizationContextProvider _authorizationContextProvider;
    @Autowired
    private LocaleResolver _localeResolver;
    @Autowired
    private FrontendLoginService _loginService;

    public AuthorizationContext getAuthorizationContextForCurrentUser(HttpServletRequest request) {
        PersonId personId = SecurityUtils.getNonnullUserId();
        TenantId tenantId = SecurityUtils.getTenantId().orElse(null);
        String locale = this._localeResolver.resolveLocale(request).getLanguage();
        try {
            return this._authorizationContextProvider.getAuthorizationContext(personId, tenantId, locale);
        }
        catch (NotLoggedInException | PermissionDeniedException e) {
            this._loginService.logout(request, ServletUtils.getResponse());
            LOGGER.warn("User {} not allowed to log in to tenant {}", (Object)personId, (Object)tenantId);
            throw new NotLoggedInException(e.getMessage(), e);
        }
    }

    public AuthorizationContext getAuthorizationContextForCurrentUser() {
        return this.getAuthorizationContextForCurrentUser(ServletUtils.getRequest());
    }

    public AuthorizationCheckContext getAuthorizationCheckContextForLoggedInOrNotLoggedInUser() {
        if (!SecurityUtils.isAuthenticatedUser()) {
            return this._authorizationContextProvider.getAuthorizationContextForNotLoggedInUser();
        }
        try {
            return this.getAuthorizationContextForCurrentUser();
        }
        catch (NotLoggedInException e) {
            return this._authorizationContextProvider.getAuthorizationContextForNotLoggedInUser();
        }
    }
}

