/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.album.presentation.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.album.presentation.client.events.ImageDeletedEvent;
import de.justsoftware.onx.album.presentation.client.ui.AlbumWidget;
import de.justsoftware.onx.album.presentation.client.ui.ImageTeaserWidget;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.album.shared.model.AlbumImage;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.presentation.client.ui.PagingWidgetProvider;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AlbumWidget
extends Composite {
    private static final AlbumWidgetUIBinder UI_BINDER = (AlbumWidgetUIBinder)GWT.create(AlbumWidgetUIBinder.class);
    @UiField
    Label _noTextBoxLabel;
    @UiField
    Panel _pagerPanel;
    private AlbumId _albumId;
    private final int _width;
    private final int _height;
    private final AlbumPager _pager;
    private ImageClickCallback _imageClickCallback;
    private AlbumPageLoadHandler _albumPageLoadHandler = null;
    private final EventManager _eventManager;
    private final EventManager.EventManagerHelper _eventManagerHelper;

    public AlbumWidget(@Nonnull AlbumId albumId, int width, int height, boolean showInsertImage, boolean showImageTitle, @Nonnull EventManager eventManager) {
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        this._eventManager = eventManager;
        this._eventManagerHelper = new EventManager.EventManagerHelper(eventManager);
        this._albumId = albumId;
        this._width = width;
        this._height = height;
        this._pager = new AlbumPager(this, this._width * this._height, showInsertImage, showImageTitle, (PagingWidgetProvider)new AlbumPagingWidgetProvider(this));
        this._pagerPanel.add((Widget)this._pager);
    }

    public void setAlbumId(@Nonnull AlbumId albumId) {
        this._albumId = albumId;
        this.update();
    }

    public void update() {
        this._pager.update();
    }

    @Nonnull
    public List<AlbumImageId> getToDeleteImages() {
        ArrayList<AlbumImageId> result = new ArrayList<AlbumImageId>();
        for (Widget w : (FlexTable)this._pager.getContentArea()) {
            ImageTeaserWidget i;
            if (!(w instanceof ImageTeaserWidget) || !(i = (ImageTeaserWidget)w).isDeleteSelected()) continue;
            result.add(i.getImage().getId());
        }
        return result;
    }

    public void setImageClickCallback(@Nullable ImageClickCallback imageClickCallback) {
        this._imageClickCallback = imageClickCallback;
    }

    public void setAlbumPageLoadHandler(@Nullable AlbumPageLoadHandler albumPageLoadHandler) {
        this._albumPageLoadHandler = albumPageLoadHandler;
    }

    static boolean isDeleteImageVisible(@Nullable ListAndCount<AlbumImage> result) {
        if (result == null || result.getMaxCount() <= 0) {
            return false;
        }
        for (AlbumImage image : result) {
            if (!image.getMay().contains((Object)StaticAction.ALBUM_DELETE)) continue;
            return true;
        }
        return false;
    }

    protected void onLoad() {
        super.onLoad();
        this._eventManagerHelper.registerListener(ImageDeletedEvent.class, event -> {
            if (this._albumId.equals((Object)event.getAlbumId())) {
                this._pager.update();
            }
        });
    }

    protected void onUnload() {
        super.onUnload();
        this._eventManagerHelper.onUnloadRemoveHandlersFromManager();
    }
}

