/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gwt.requestcollect.client;

import com.freiheit.toro.common.shared.util.UrlUtil;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.impl.RemoteServiceProxy;
import com.google.gwt.user.client.rpc.impl.RequestCallbackAdapter;
import de.justsoftware.gwt.requestcollect.client.AbstractRequestCollectorCache;
import de.justsoftware.gwt.requestcollect.client.IRequestBundler;
import de.justsoftware.gwt.requestcollect.client.RequestAndCallback;
import de.justsoftware.gwt.requestcollect.client.RequestCollector;
import de.justsoftware.gwt.requestcollect.client.RequestCollectorControl;
import de.justsoftware.gwt.requestcollect.shared.RequestCollectorRemoteService;
import de.justsoftware.gwt.requestcollect.shared.RequestCollectorRemoteServiceAsync;
import de.justsoftware.gwt.requestcollect.shared.RequestCollectorRequest;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class RequestCollector
implements RequestCollectorControl {
    public static final RequestCollector INSTANCE = new RequestCollector();
    private final RequestCollectorRemoteServiceAsync _requestControllerRemoteService = this.createRemoteService();
    private final Map<CacheClassAndName, AbstractRequestCollectorCache> _cache = Maps.newHashMap();
    private final LinkedList<IRequestBundler> _bundlers = Lists.newLinkedList();
    private final LinkedList<IRequestBundler> _parasiteBundlers = Lists.newLinkedList();
    private final Scheduler.ScheduledCommand _scheduledCommand = new /* Unavailable Anonymous Inner Class!! */;
    private boolean _isScheduled = false;
    private final List<RequestAndCallback> _queue = Lists.newLinkedList();

    private RequestCollector() {
    }

    @Nonnull
    private RequestCollectorRemoteServiceAsync createRemoteService() {
        RequestCollectorRemoteServiceAsync result = (RequestCollectorRemoteServiceAsync)GWT.create(RequestCollectorRemoteService.class);
        UrlUtil.setRemoteServiceUrl((Object)result, (String)"/collector");
        return result;
    }

    public void collectRequest(RemoteServiceProxy proxy, RequestCallbackAdapter.ResponseReader responseReader, String requestData, AsyncCallback<?> callback) {
        String path = proxy.getServiceEntryPoint().substring("/toro/rpc".length());
        RequestCollectorRequest request = new RequestCollectorRequest(path, requestData);
        this._queue.add(new RequestAndCallback(proxy, request, responseReader, callback));
        this.scheduleTimer();
    }

    public void scheduleTimer() {
        if (!this._isScheduled) {
            this._isScheduled = true;
            Scheduler.get().scheduleDeferred(this._scheduledCommand);
        }
    }

    public native boolean isEnabled();

    @Nonnull
    public <T extends AbstractRequestCollectorCache> T registerCache(T cache) {
        CacheClassAndName cacheClassAndName = new CacheClassAndName(cache._asyncControllerClass, cache._name);
        AbstractRequestCollectorCache existing = (AbstractRequestCollectorCache)this._cache.get(cacheClassAndName);
        if (existing != null) {
            return (T)existing;
        }
        this._cache.put(cacheClassAndName, cache);
        return cache;
    }

    public <T extends IRequestBundler> T registerParasiteBundler(T bundler) {
        this._parasiteBundlers.add(bundler);
        return bundler;
    }

    public <T extends IRequestBundler> T registerBundler(T bundler) {
        this._bundlers.add(bundler);
        return bundler;
    }

    public boolean unregisterBundler(IRequestBundler bundler) {
        boolean wasParasite = this._parasiteBundlers.remove(bundler);
        boolean wasNormal = this._bundlers.remove(bundler);
        return wasParasite || wasNormal;
    }

    @Nonnull
    private AbstractRequestCollectorCache getCache(Class<?> asyncRemoteServiceClass, String cacheName) {
        AbstractRequestCollectorCache cache = (AbstractRequestCollectorCache)this._cache.get(new CacheClassAndName(asyncRemoteServiceClass, cacheName));
        if (cache == null) {
            throw new IllegalArgumentException("tried to access non existent cache!");
        }
        return cache;
    }

    public void invalidateKeys(Class<?> asyncRemoteServiceClass, String cacheName, Iterable<?> keys) {
        this.getCache(asyncRemoteServiceClass, cacheName).invalidateKeys(keys);
    }

    public void invalidateKey(Class<?> asyncRemoteServiceClass, String cacheName, Object key) {
        this.invalidateKeys(asyncRemoteServiceClass, cacheName, (Iterable)ImmutableSet.of((Object)key));
    }

    public void invalidateKey(Class<?> asyncRemoteServiceClass, String cacheName, Object ... keys) {
        this.invalidateKeys(asyncRemoteServiceClass, cacheName, (Iterable)ImmutableSet.copyOf((Object[])keys));
    }

    public void invalidateCache(Class<?> asyncRemoteServiceClass, String cacheName) {
        this.getCache(asyncRemoteServiceClass, cacheName).invalidateAll();
    }
}

