/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.auth;

import de.justsoftware.onx.security.jwt.JwtCookieManager;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.RememberMeAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

@ParametersAreNonnullByDefault
public class JustIdCookieOnRememberMeFilter
extends OncePerRequestFilter {
    private final JwtCookieManager _jwtCookieManager;

    JustIdCookieOnRememberMeFilter(JwtCookieManager jwtCookieManager) {
        this._jwtCookieManager = jwtCookieManager;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof RememberMeAuthenticationToken) {
            this._jwtCookieManager.addCookie(request, response, authentication);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

