/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.common.presentation.client.validator;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.client.validator.Validatable;
import com.freiheit.toro.common.shared.model.ValidationException;
import com.google.gwt.user.client.ui.TextBox;

public class ValidatableTextBox
extends TextBox
implements Validatable {
    protected String _fieldName;
    protected int _maxLength = Integer.MAX_VALUE;
    protected boolean _mandatory = false;

    public ValidatableTextBox(String fieldName) {
        this._fieldName = fieldName == null ? "null" : fieldName;
    }

    public ValidatableTextBox() {
    }

    public ValidatableTextBox(String fieldName, int maxLength) {
        this(fieldName);
        this._maxLength = maxLength;
    }

    public ValidatableTextBox(String fieldName, int maxLength, boolean mandatory) {
        this(fieldName);
        this._maxLength = maxLength;
        this._mandatory = mandatory;
    }

    public void validate() throws ValidationException {
        int length;
        String text = this.getText();
        int n = length = text != null ? text.trim().length() : 0;
        if (this.isMandatory() && (text == null || length <= 0)) {
            throw new ValidationException(I18nMediator.BASIC_MESSAGES.fillFieldx(this._fieldName));
        }
        if (length > this.getMaxLength()) {
            throw new ValidationException(I18nMediator.BASIC_MESSAGES.tooLong(this._fieldName));
        }
    }

    public boolean isMandatory() {
        return this._mandatory;
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public void setMaxLength(int maxLength) {
        super.setMaxLength(maxLength);
        this._maxLength = maxLength;
    }

    public void setMandatory(boolean mandatory) {
        this._mandatory = mandatory;
    }

    public void setFieldName(String fieldName) {
        this._fieldName = fieldName;
    }

    public String getFieldName() {
        return this._fieldName;
    }

    protected boolean isNavigationKey(int nativeEventCode) {
        switch (nativeEventCode) {
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 27: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 46: {
                return true;
            }
        }
        return false;
    }
}

