/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.shared.i18n.BasicConstants;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.JCDialogBox;

public class MessagePopup
extends JCDialogBox {
    public static final int WARNING = 0;
    public static final int ERROR = 1;
    public static final int INFO = 2;
    public static final int SUCCESS = 3;
    public static final int QUESTION = 4;
    protected static final String DEFAULT_STYLE = "popupModal";
    private static final BasicConstants BASIC = I18nMediator.BASIC;
    private static final String[] TYPES = new String[]{"warning", "error", "info", "success", "question"};
    private final JCButton _closeButton;
    private JCButton _focusButton;
    private int _curType = -1;

    public MessagePopup(boolean autoHide, boolean modal) {
        super(autoHide, modal);
        this.setText(BASIC.info());
        this._focusButton = this._closeButton = new JCButton(BASIC.close(), event -> this.hide());
        this.addButton(this._closeButton);
        this.setWidget((Widget)this._container);
    }

    public void show() {
        super.show();
        if (this._focusButton != null) {
            this._focusButton.setFocus(true);
        }
    }

    public void hideCloseButton() {
        if (this._focusButton == this._closeButton) {
            this._focusButton = null;
        }
        this._buttonPanel.remove((Widget)this._closeButton);
    }

    public void setType(int type) {
        if (type > -1 && type < TYPES.length) {
            switch (type) {
                case 1: {
                    this.setText(BASIC.errorDialogTitle());
                    break;
                }
                case 0: {
                    this.setText(BASIC.warningDialogTitle());
                    break;
                }
                case 2: {
                    this.setText(BASIC.infoDialogTitle());
                    break;
                }
                case 3: {
                    this.setText(BASIC.successDialogTitle());
                    break;
                }
                case 4: {
                    this.setText(BASIC.questionDialogTitle());
                    break;
                }
                default: {
                    this.setText("");
                }
            }
        }
        if (this._curType > -1) {
            this.removeStyleName(TYPES[this._curType]);
        }
        if (type > -1 && type < TYPES.length) {
            this.addStyleName(TYPES[type]);
        }
        this._curType = type;
    }

    public void setMessage(String message) {
        this.setMessage((Widget)new Label(message));
    }

    public void setMessage(Widget message) {
        this.setContent((IsWidget)message);
    }

    public void addFocusButton(JCButton button) {
        this.addButton(button);
        this._focusButton = button;
    }

    public void showCentral() {
        this.setPopupPositionAndShow((offsetWidth, offsetHeight) -> {
            int left = (Window.getClientWidth() - offsetWidth) / 2;
            int top = (Window.getClientHeight() - offsetHeight) / 4;
            this.setPopupPosition(left, top);
        });
    }

    public void setContent(IsWidget newcontent) {
        super.setContent(newcontent);
        this.addContentStyle("message-popup-content");
    }
}

