/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.admin.presentation.server;

import com.freiheit.toro.admin.presentation.client.AdminController;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.admin.SuperAdminService;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.shared.model.Type;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.license.business.LicenseService;
import de.justsoftware.onx.license.shared.model.LicenseInfo;
import de.justsoftware.onx.notifications.business.NotificationMigrationService;
import de.justsoftware.onx.process.business.ProcessAdministrationService;
import de.justsoftware.onx.searchnew.shared.model.LearnToRankTriggerResult;
import de.justsoftware.onx.searchnew.shared.model.SearchIndexType;
import javax.annotation.Nullable;
import org.springframework.stereotype.Service;

@Service
public class AdminControllerImpl
implements AdminController {
    private final SessionAuthorizationContextProvider _authorizationContextProvider;
    private final ProcessAdministrationService _processAdministrationService;
    private final NotificationMigrationService _notificationMigrationService;
    private final SuperAdminService _superAdminService;
    private final LicenseService _licenseService;

    public AdminControllerImpl(SessionAuthorizationContextProvider authorizationContextProvider, ProcessAdministrationService processAdministrationService, NotificationMigrationService notificationMigrationService, SuperAdminService superAdminService, LicenseService licenseService) {
        this._authorizationContextProvider = authorizationContextProvider;
        this._processAdministrationService = processAdministrationService;
        this._notificationMigrationService = notificationMigrationService;
        this._superAdminService = superAdminService;
        this._licenseService = licenseService;
    }

    public void syncAllPermissions() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.syncAllPermissions();
    }

    public void syncJustPeople() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.syncJustPeople();
    }

    public void syncJustDrive() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.syncJustDrive();
    }

    public void flushCache() {
        this.authCtx().check((Action)StaticAction.ADMIN_FLUSH_CACHE);
        this._superAdminService.flushCache();
    }

    public void reloadOverrideLess() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_FLUSH_CACHE);
        this._superAdminService.reloadOverrideLess();
    }

    public void reloadConfigFile() {
        this.authCtx().check((Action)StaticAction.ADMIN_RELOAD_CONFIG);
        this._superAdminService.reloadConfigFile();
    }

    private AuthorizationContext authCtx() {
        return this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
    }

    public void adjustEntityStatus() {
        this._processAdministrationService.adjustEntityStatus((AuthorizationCheckContext)this.authCtx());
    }

    public void reindex(ImmutableSet<? extends Type> searchTypes, boolean reindexAppSpecificSearches) {
        this.authCtx().check((Action)StaticAction.ADMIN_SEARCH_REINDEX);
        this._superAdminService.reindex(searchTypes, reindexAppSpecificSearches);
    }

    public void reindexChat() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_SEARCH_REINDEX);
        this._superAdminService.reindexChat();
    }

    public void reindexChatsInCommonCore() {
        this.authCtx().check((Action)StaticAction.ADMIN_SEARCH_REINDEX);
        this._superAdminService.reindexChatsInCommonCore();
    }

    public void reindexChatCore() {
        this.authCtx().check((Action)StaticAction.ADMIN_SEARCH_REINDEX);
        this._superAdminService.reindexChatCore();
    }

    public void reindexDriveMetadata() {
        this.authCtx().check((Action)StaticAction.ADMIN_SEARCH_REINDEX);
        this._superAdminService.reindexDriveMetadata();
    }

    public void syncPersonData() {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.syncPersonData();
    }

    public void syncPrivacySettings() {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.syncPrivacySettings();
    }

    public void syncRoles() {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.syncRoles();
    }

    public void syncDrivePermissions() {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.syncDrivePermissions();
    }

    public void syncPeopleUserGroups() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.syncPeopleUserGroups();
    }

    public void syncWikiPermissions() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.syncWikiPermissions();
    }

    public void reindexWiki() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_SEARCH_REINDEX);
        this._superAdminService.reindexWiki();
    }

    public void reindexWikiContainers() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_SEARCH_REINDEX);
        this._superAdminService.reindexWikiContainers();
    }

    public void reindexWikiChapters() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_SEARCH_REINDEX);
        this._superAdminService.reindexWikiChapters();
    }

    public void reindexWikiArticles() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_SEARCH_REINDEX);
        this._superAdminService.reindexWikiArticles();
    }

    public void syncToroPermissions() {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.syncToroPermissions();
    }

    public void syncChatPermissions() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.syncChatPermissions();
    }

    public void runDriveHistoryCompactionJob() {
        this.authCtx().check((Action)StaticAction.ADMIN_SYSTEM_ADMINISTRATION);
        this._superAdminService.runDriveHistoryCompactionJob();
    }

    public void reindexPeopleUserGroups() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_SEARCH_REINDEX);
        this._superAdminService.reindexPeopleUserGroups();
    }

    public void syncDocuments() {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.syncDocuments();
    }

    public void indexEntityAnchors() {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.indexEntityAnchors();
    }

    public void syncEntityItems() {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.syncEntityItems();
    }

    public LearnToRankTriggerResult searchLTRTrain() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_SEARCH_LTR_ADMIN);
        return this._superAdminService.searchLTRTrain();
    }

    public LearnToRankTriggerResult searchLTRReset() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_SEARCH_LTR_ADMIN);
        return this._superAdminService.searchLTRReset();
    }

    public LearnToRankTriggerResult searchLTRUpdateUpcomingFeatures() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_SEARCH_LTR_ADMIN);
        return this._superAdminService.searchLTRUpdateUpcomingFeatures();
    }

    public LicenseInfo getLicenseInfo() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_IMPORT_EXTERNAL_PERSONS);
        return this._licenseService.getLicenseInfo();
    }

    @Deprecated
    public void runMigrateNotificationJob() {
        this.authCtx().check((Action)StaticAction.ADMIN_MIGRATE_NOTIFICATIONS);
        this._notificationMigrationService.startMigrate();
    }

    public void syncConversationNodes() {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.clearAndSyncChatNodes();
    }

    public void reindexSolrJustSocialCore(@Nullable SearchIndexType searchIndexType) {
        this.authCtx().check((Action)StaticAction.ADMIN_SEARCH_REINDEX);
        this._superAdminService.reindexSolrJustSocialCore(searchIndexType);
    }
}

