/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.search.kafka;

import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.kafka.client.KafkaCleaningProducerImpl;
import de.justsoftware.search.kafka.KafkaConfiguration;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.TopicPartition;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u0001\u000eB\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tH\u0017J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0012J\b\u0010\r\u001a\u00020\u000bH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/justsoftware/search/kafka/KafkaConfiguration;", "", "bootstrapServers", "", "defaultMaxChunkSize", "", "<init>", "(Ljava/lang/String;I)V", "createStringProducer", "Lde/justsoftware/kafka/client/KafkaCleaningProducer;", "defaultConsumerConfig", "Ljava/util/Properties;", "groupId", "defaultProducerConfig", "ClosingKafkaProducer", "search-service"})
@SourceDebugExtension(value={"SMAP\nKafkaConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KafkaConfiguration.kt\nde/justsoftware/search/kafka/KafkaConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
public class KafkaConfiguration {
    @NotNull
    private final String bootstrapServers;
    private final int defaultMaxChunkSize;

    public KafkaConfiguration(@Value(value="${spring.kafka.bootstrap-servers}") @NotNull String bootstrapServers, @Value(value="${kafka.consumer-max-chunk-size:100}") int defaultMaxChunkSize) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        this.bootstrapServers = bootstrapServers;
        this.defaultMaxChunkSize = defaultMaxChunkSize;
    }

    @Bean(destroyMethod="close")
    @NotNull
    public KafkaCleaningProducer<String, String> createStringProducer() {
        return (KafkaCleaningProducer)new KafkaCleaningProducerImpl((Producer)new ClosingKafkaProducer(this.defaultProducerConfig()), arg_0 -> KafkaConfiguration.createStringProducer$lambda$0(this, arg_0));
    }

    private Properties defaultConsumerConfig(String groupId) {
        Properties properties;
        block0: {
            String string;
            Properties $this$defaultConsumerConfig_u24lambda_u242 = properties = new Properties();
            boolean bl = false;
            $this$defaultConsumerConfig_u24lambda_u242.put("bootstrap.servers", this.bootstrapServers);
            $this$defaultConsumerConfig_u24lambda_u242.put("enable.auto.commit", "false");
            $this$defaultConsumerConfig_u24lambda_u242.put("auto.offset.reset", "earliest");
            $this$defaultConsumerConfig_u24lambda_u242.put("max.poll.records", (Object)this.defaultMaxChunkSize);
            String string2 = groupId;
            if (string2 == null) break block0;
            String $this$defaultConsumerConfig_u24lambda_u242_u24lambda_u241 = string = string2;
            boolean bl2 = false;
            $this$defaultConsumerConfig_u24lambda_u242.put("group.id", groupId);
        }
        return properties;
    }

    private Properties defaultProducerConfig() {
        Properties properties;
        Properties $this$defaultProducerConfig_u24lambda_u243 = properties = new Properties();
        boolean bl = false;
        $this$defaultProducerConfig_u24lambda_u243.put("bootstrap.servers", this.bootstrapServers);
        $this$defaultProducerConfig_u24lambda_u243.put("acks", "all");
        $this$defaultProducerConfig_u24lambda_u243.put("retries", (Object)0);
        $this$defaultProducerConfig_u24lambda_u243.put("batch.size", (Object)16384);
        $this$defaultProducerConfig_u24lambda_u243.put("linger.ms", (Object)1);
        $this$defaultProducerConfig_u24lambda_u243.put("buffer.memory", (Object)0x2000000);
        return properties;
    }

    private static final Consumer createStringProducer$lambda$0(KafkaConfiguration this$0, TopicPartition topicPartition) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return KafkaCleaningProducerImpl.createStringConsumer((TopicPartition)topicPartition, (Properties)this$0.defaultConsumerConfig(null));
    }
}

