/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.search.business;

import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.search.business.SolrIndexService;
import de.justsoftware.search.shared.SolrIndexQueue;
import de.justsoftware.search.shared.model.JustSocialSolrDocument;
import de.justsoftware.search.shared.model.SearchType;
import de.justsoftware.search.shared.model.SearchableId;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0017\u0018\u0000 $2\u00020\u0001:\u0002#$B!\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0016\u0010\u0015\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0011H\u0016J\u001a\u0010\u001c\u001a\u00020\u0011*\u00020\u000b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0013H\u0012J\u001a\u0010\u001f\u001a\u00020\u0011*\u00020\u000b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0013H\u0012J\u001a\u0010\u0015\u001a\u00020\u0011*\u00020\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020 0\u0013H\u0012J\u001a\u0010!\u001a\u00020\u0011*\u00020\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020 0\u0013H\u0012J\u001a\u0010\"\u001a\u00020\u0011*\u00020\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020 0\u0013H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u00020\u000b8\u0010X\u0091\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006%"}, d2={"Lde/justsoftware/search/business/SolrIndexService;", "", "justSocialCoreLeaderSolrClient", "Lorg/apache/solr/client/solrj/SolrClient;", "solrIndexQueue", "Lde/justsoftware/search/shared/SolrIndexQueue;", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "<init>", "(Lorg/apache/solr/client/solrj/SolrClient;Lde/justsoftware/search/shared/SolrIndexQueue;Lio/micrometer/core/instrument/MeterRegistry;)V", "justSocialSolrCore", "Lde/justsoftware/search/business/SolrIndexService$SolrCore;", "getJustSocialSolrCore$search_service$annotations", "()V", "getJustSocialSolrCore$search_service", "()Lde/justsoftware/search/business/SolrIndexService$SolrCore;", "indexSolrDocuments", "", "docs", "", "Lde/justsoftware/search/shared/model/JustSocialSolrDocument;", "deleteSolrDocuments", "ids", "Lde/justsoftware/search/shared/model/SearchableId;", "reindex", "type", "Lde/justsoftware/search/shared/model/SearchType;", "reindexAll", "addSolrDocuments", "documents", "Lorg/apache/solr/common/SolrInputDocument;", "addSolrDocumentsIndividually", "", "deleteSolrDocumentsByParentIds", "deleteSolrDocumentsIndividually", "SolrCore", "Companion", "search-service"})
@SourceDebugExtension(value={"SMAP\nSolrIndexService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolrIndexService.kt\nde/justsoftware/search/business/SolrIndexService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 LoggerUtils.kt\nde/justsoftware/search/util/LoggerUtilsKt\n*L\n1#1,226:1\n1557#2:227\n1628#2,3:228\n1557#2:231\n1628#2,3:232\n1863#2,2:235\n1863#2,2:237\n8#3:239\n7#3,3:240\n*S KotlinDebug\n*F\n+ 1 SolrIndexService.kt\nde/justsoftware/search/business/SolrIndexService\n*L\n61#1:227\n61#1:228,3\n66#1:231\n66#1:232,3\n99#1:235,2\n143#1:237,2\n155#1:239\n155#1:240,3\n*E\n"})
public class SolrIndexService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SolrClient justSocialCoreLeaderSolrClient;
    @NotNull
    private final SolrIndexQueue solrIndexQueue;
    @NotNull
    private final SolrCore justSocialSolrCore;
    @NotNull
    private static final Logger LOG;

    public SolrIndexService(@Qualifier(value="justSocialCoreLeaderSolrClient") @NotNull SolrClient justSocialCoreLeaderSolrClient, @NotNull SolrIndexQueue solrIndexQueue, @NotNull MeterRegistry meterRegistry) {
        Intrinsics.checkNotNullParameter((Object)justSocialCoreLeaderSolrClient, (String)"justSocialCoreLeaderSolrClient");
        Intrinsics.checkNotNullParameter((Object)solrIndexQueue, (String)"solrIndexQueue");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        this.justSocialCoreLeaderSolrClient = justSocialCoreLeaderSolrClient;
        this.solrIndexQueue = solrIndexQueue;
        this.justSocialSolrCore = new SolrCore("justsocial", this.justSocialCoreLeaderSolrClient, meterRegistry);
    }

    @NotNull
    public SolrCore getJustSocialSolrCore$search_service() {
        return this.justSocialSolrCore;
    }

    @VisibleForTesting
    public static /* synthetic */ void getJustSocialSolrCore$search_service$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    public void indexSolrDocuments(@NotNull List<? extends JustSocialSolrDocument> docs) {
        Collection<SolrInputDocument> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(docs, (String)"docs");
        if (docs.isEmpty()) {
            return;
        }
        Iterable iterable = docs;
        SolrCore solrCore = this.getJustSocialSolrCore$search_service();
        SolrIndexService solrIndexService = this;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JustSocialSolrDocument justSocialSolrDocument = (JustSocialSolrDocument)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Companion.access$toSolrDocument((Companion)Companion, (JustSocialSolrDocument)it));
        }
        collection = (List)destination$iv$iv;
        solrIndexService.addSolrDocuments(solrCore, (List)collection);
    }

    /*
     * WARNING - void declaration
     */
    public void deleteSolrDocuments(@NotNull List<SearchableId> ids) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        if (ids.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = ids;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            SearchableId searchableId = (SearchableId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        List canonicalIds = (List)destination$iv$iv;
        this.deleteSolrDocuments(this.getJustSocialSolrCore$search_service(), canonicalIds);
        this.deleteSolrDocumentsByParentIds(this.getJustSocialSolrCore$search_service(), canonicalIds);
    }

    public void reindex(@NotNull SearchType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        LOG.info("Reindex for " + type + " triggered");
        this.justSocialCoreLeaderSolrClient.deleteByQuery("type:" + type);
        SolrIndexQueue.reindex$default((SolrIndexQueue)this.solrIndexQueue, (Set)SetsKt.setOf((Object)type), null, (int)2, null);
    }

    public void reindexAll() {
        LOG.info("Reindex all triggered");
        this.justSocialCoreLeaderSolrClient.deleteByQuery("*:*");
        SolrIndexQueue.reindex$default((SolrIndexQueue)this.solrIndexQueue, (Set)ArraysKt.toSet((Object[])SearchType.values()), null, (int)2, null);
    }

    private void addSolrDocuments(SolrCore $this$addSolrDocuments, List<? extends SolrInputDocument> documents) {
        if (documents.isEmpty()) {
            return;
        }
        try {
            $this$addSolrDocuments.getClient().add((Collection)documents);
            $this$addSolrDocuments.getSuccessfulIndexedDocumentCount().addAndGet(documents.size());
        }
        catch (SolrServerException e) {
            if (e.getCause() instanceof IOException) {
                throw e;
            }
            LOG.warn("Batch adding of " + documents.size() + " documents for solr core " + $this$addSolrDocuments.getCoreName() + " failed. Try to add documents individually.", (Throwable)e);
            this.addSolrDocumentsIndividually($this$addSolrDocuments, documents);
        }
    }

    private void addSolrDocumentsIndividually(SolrCore $this$addSolrDocumentsIndividually, List<? extends SolrInputDocument> documents) {
        Iterable $this$forEach$iv = documents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SolrInputDocument document = (SolrInputDocument)element$iv;
            boolean bl = false;
            try {
                $this$addSolrDocumentsIndividually.getClient().add(document);
                $this$addSolrDocumentsIndividually.getSuccessfulIndexedDocumentCount().incrementAndGet();
            }
            catch (SolrServerException e) {
                if (e.getCause() instanceof IOException) {
                    throw e;
                }
                SolrInputField solrInputField = (SolrInputField)document.get((Object)"id");
                LOG.error("Failed to index solr document for " + (solrInputField != null ? solrInputField.getValue() : null) + " in solr core " + $this$addSolrDocumentsIndividually.getCoreName(), (Throwable)e);
                $this$addSolrDocumentsIndividually.getFailedIndexedDocumentCount().incrementAndGet();
            }
        }
    }

    private void deleteSolrDocuments(SolrCore $this$deleteSolrDocuments, List<String> ids) {
        if (ids.isEmpty()) {
            return;
        }
        try {
            $this$deleteSolrDocuments.getClient().deleteById(ids);
            $this$deleteSolrDocuments.getSuccessfulIndexedDocumentCount().addAndGet(ids.size());
        }
        catch (SolrServerException e) {
            if (e.getCause() instanceof IOException) {
                throw e;
            }
            LOG.warn("Batch deletion of " + ids.size() + " documents for solr core " + $this$deleteSolrDocuments.getCoreName() + " failed. Try to delete documents individually.", (Throwable)e);
            this.deleteSolrDocumentsIndividually($this$deleteSolrDocuments, ids);
        }
    }

    private void deleteSolrDocumentsByParentIds(SolrCore $this$deleteSolrDocumentsByParentIds, List<String> ids) {
        if (ids.isEmpty()) {
            return;
        }
        try {
            $this$deleteSolrDocumentsByParentIds.getClient().deleteByQuery("{!edismax q.op=AND qf='parent_id visible_by_parent_id restricted_visible_by_parent_id' mm=1}" + ClientUtils.escapeQueryChars((String)CollectionsKt.joinToString$default((Iterable)ids, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)));
        }
        catch (SolrServerException e) {
            if (e.getCause() instanceof IOException) {
                throw e;
            }
            LOG.error("Batch deletion of children documents for solr core " + $this$deleteSolrDocumentsByParentIds.getCoreName() + " failed. Skip deletion of children.", (Throwable)e);
        }
    }

    private void deleteSolrDocumentsIndividually(SolrCore $this$deleteSolrDocumentsIndividually, List<String> ids) {
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String id = (String)element$iv;
            boolean bl = false;
            try {
                $this$deleteSolrDocumentsIndividually.getClient().deleteById(id);
                $this$deleteSolrDocumentsIndividually.getSuccessfulIndexedDocumentCount().incrementAndGet();
            }
            catch (SolrServerException e) {
                if (e.getCause() instanceof IOException) {
                    throw e;
                }
                LOG.error("Failed to delete solr document " + id + " from solr core " + $this$deleteSolrDocumentsIndividually.getCoreName(), (Throwable)e);
                $this$deleteSolrDocumentsIndividually.getFailedIndexedDocumentCount().incrementAndGet();
            }
        }
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

