/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.searchltr.tracking;

import de.justsoftware.searchltr.tracking.TrackingMessage;
import de.justsoftware.searchltr.tracking.TrackingMessageKafkaConsumer;
import de.justsoftware.searchltr.tracking.TrackingMessageService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/justsoftware/searchltr/tracking/TrackingMessageKafkaConsumer;", "", "trackingMessageService", "Lde/justsoftware/searchltr/tracking/TrackingMessageService;", "<init>", "(Lde/justsoftware/searchltr/tracking/TrackingMessageService;)V", "listen", "", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "", "Lde/justsoftware/searchltr/tracking/TrackingMessage;", "Companion", "search-ltr"})
@SourceDebugExtension(value={"SMAP\nTrackingMessageKafkaConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrackingMessageKafkaConsumer.kt\nde/justsoftware/searchltr/tracking/TrackingMessageKafkaConsumer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 LoggerUtils.kt\nde/justsoftware/searchltr/util/LoggerUtilsKt\n*L\n1#1,40:1\n1863#2,2:41\n9#3:43\n8#3,3:44\n*S KotlinDebug\n*F\n+ 1 TrackingMessageKafkaConsumer.kt\nde/justsoftware/searchltr/tracking/TrackingMessageKafkaConsumer\n*L\n24#1:41,2\n37#1:43\n37#1:44,3\n*E\n"})
public class TrackingMessageKafkaConsumer {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final TrackingMessageService trackingMessageService;
    @NotNull
    private static final Logger LOG;

    public TrackingMessageKafkaConsumer(@NotNull TrackingMessageService trackingMessageService) {
        Intrinsics.checkNotNullParameter((Object)trackingMessageService, (String)"trackingMessageService");
        this.trackingMessageService = trackingMessageService;
    }

    @KafkaListener(id="just.search.ltr.trackingMessageConsumer", containerFactory="trackingMessageListenerContainerFactory", topics={"just.search.ltr.tracking"})
    public void listen(@NotNull ConsumerRecords<String, TrackingMessage> records) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable $this$forEach$iv = (Iterable)records;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConsumerRecord record = (ConsumerRecord)element$iv;
            boolean bl = false;
            try {
                Object object = record.value();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
                this.trackingMessageService.handleTrackingMessage((TrackingMessage)object);
            }
            catch (RuntimeException e) {
                LOG.error("Failed to process search tracking record with id '" + record.key() + "'.' Skip this record.", (Throwable)e);
            }
        }
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

