/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.searchltr.solr;

import de.justsoftware.searchltr.LTRFeatureConfiguration;
import de.justsoftware.searchltr.ToroAPI;
import de.justsoftware.searchltr.config.SearchLTRConfigProperties;
import de.justsoftware.searchltr.config.ZookeeperService;
import de.justsoftware.searchltr.solr.LTRFeatureDefinition;
import de.justsoftware.searchltr.solr.LTRModel;
import de.justsoftware.searchltr.solr.SolrClient;
import de.justsoftware.searchltr.solr.Solrs;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 ,2\u00020\u0001:\u0001,B9\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0001\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u001b\u001a\u00020\u001cH\u0017J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u0003H\u0016J\b\u0010#\u001a\u00020\u001cH\u0016J\u001a\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u00032\u0006\u0010'\u001a\u00020(H\u0012J\u001a\u0010)\u001a\u00020%2\b\u0010*\u001a\u0004\u0018\u00010\u00032\u0006\u0010+\u001a\u00020\u0003H\u0012R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006-"}, d2={"Lde/justsoftware/searchltr/solr/Solrs;", "", "leaderCommonUrl", "", "replicaSolrUrls", "", "toroAPI", "Lde/justsoftware/searchltr/ToroAPI;", "searchLTRConfigProperties", "Lde/justsoftware/searchltr/config/SearchLTRConfigProperties;", "zookeeperService", "Lde/justsoftware/searchltr/config/ZookeeperService;", "<init>", "(Ljava/lang/String;Ljava/util/List;Lde/justsoftware/searchltr/ToroAPI;Lde/justsoftware/searchltr/config/SearchLTRConfigProperties;Lde/justsoftware/searchltr/config/ZookeeperService;)V", "getToroAPI", "()Lde/justsoftware/searchltr/ToroAPI;", "getSearchLTRConfigProperties", "()Lde/justsoftware/searchltr/config/SearchLTRConfigProperties;", "getZookeeperService", "()Lde/justsoftware/searchltr/config/ZookeeperService;", "leaderSolrClient", "Lde/justsoftware/searchltr/solr/SolrClient;", "getLeaderSolrClient", "()Lde/justsoftware/searchltr/solr/SolrClient;", "allSolrClients", "getAllSolrClients", "()Ljava/util/List;", "initFeatureDefinitions", "", "updateUpcomingFeatureStore", "uploadLTRModel", "ltrModel", "Lde/justsoftware/searchltr/solr/LTRModel;", "deleteLTRModel", "model", "deleteAllLTRModelsAndFeatures", "areFeatureStoresUpToDate", "", "storeName", "ltrFeatureConfig", "Lde/justsoftware/searchltr/LTRFeatureConfiguration;", "updateLTRFeatureDefinitions", "currentStoreName", "newStoreName", "Companion", "search-ltr"})
@SourceDebugExtension(value={"SMAP\nSolrs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Solrs.kt\nde/justsoftware/searchltr/solr/Solrs\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 LoggerUtils.kt\nde/justsoftware/searchltr/util/LoggerUtilsKt\n*L\n1#1,188:1\n1557#2:189\n1628#2,3:190\n1863#2,2:193\n1863#2,2:195\n1863#2,2:197\n1863#2,2:199\n1863#2,2:201\n9#3:203\n8#3,3:204\n*S KotlinDebug\n*F\n+ 1 Solrs.kt\nde/justsoftware/searchltr/solr/Solrs\n*L\n33#1:189\n33#1:190,3\n72#1:193,2\n85#1:195,2\n98#1:197,2\n117#1:199,2\n144#1:201,2\n153#1:203\n153#1:204,3\n*E\n"})
public class Solrs {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ToroAPI toroAPI;
    @NotNull
    private final SearchLTRConfigProperties searchLTRConfigProperties;
    @NotNull
    private final ZookeeperService zookeeperService;
    @NotNull
    private final SolrClient leaderSolrClient;
    @NotNull
    private final List<SolrClient> allSolrClients;
    @NotNull
    private static final Logger LOG;
    private static final DateTimeFormatter dateFormatter;
    @NotNull
    private static final String OLD_UPCOMING_FEATURES_STORE_NAME_PATH = "/just/search/ltr/featureStoreName/justSearchUpcomingFeatureStore";
    @NotNull
    private static final String OLD_MODEL_NAME_PATH = "/just/search/ltr/modelStoreName/justSearchModel";
    @NotNull
    private static final String OLD_SEARCH_LTR_NODE = "/just/search/ltr";

    /*
     * WARNING - void declaration
     */
    public Solrs(@Value(value="${solr.leaderCommonCoreUrl:http://localhost:8983/solr/common}") @NotNull String leaderCommonUrl, @Value(value="${solr.replicaCommonCoreUrls:}") @NotNull List<String> replicaSolrUrls, @NotNull ToroAPI toroAPI, @NotNull SearchLTRConfigProperties searchLTRConfigProperties, @NotNull ZookeeperService zookeeperService) {
        Collection<SolrClient> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)leaderCommonUrl, (String)"leaderCommonUrl");
        Intrinsics.checkNotNullParameter(replicaSolrUrls, (String)"replicaSolrUrls");
        Intrinsics.checkNotNullParameter((Object)toroAPI, (String)"toroAPI");
        Intrinsics.checkNotNullParameter((Object)searchLTRConfigProperties, (String)"searchLTRConfigProperties");
        Intrinsics.checkNotNullParameter((Object)zookeeperService, (String)"zookeeperService");
        this.toroAPI = toroAPI;
        this.searchLTRConfigProperties = searchLTRConfigProperties;
        this.zookeeperService = zookeeperService;
        LOG.info("Initializing Solr");
        this.leaderSolrClient = new SolrClient(leaderCommonUrl);
        Iterable iterable = replicaSolrUrls;
        Collection collection2 = CollectionsKt.listOf((Object)this.leaderSolrClient);
        Solrs solrs = this;
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void url;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SolrClient((String)url));
        }
        collection = (List)destination$iv$iv;
        solrs.allSolrClients = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
    }

    @NotNull
    public ToroAPI getToroAPI() {
        return this.toroAPI;
    }

    @NotNull
    public SearchLTRConfigProperties getSearchLTRConfigProperties() {
        return this.searchLTRConfigProperties;
    }

    @NotNull
    public ZookeeperService getZookeeperService() {
        return this.zookeeperService;
    }

    @NotNull
    public final SolrClient getLeaderSolrClient() {
        return this.leaderSolrClient;
    }

    @NotNull
    public final List<SolrClient> getAllSolrClients() {
        return this.allSolrClients;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void initFeatureDefinitions() {
        Companion.access$doWithRetryBackOff((Companion)Companion, () -> Solrs.initFeatureDefinitions$lambda$1(this));
    }

    public void updateUpcomingFeatureStore() {
        String newUpcomingFeatureStoreName;
        boolean featureStoreWasUpdated;
        LOG.info("Check if LTR upcoming feature definitions already exist");
        String currentUpcomingFeaturesStoreName = this.getSearchLTRConfigProperties().getUpcomingFeaturesStoreName();
        if (currentUpcomingFeaturesStoreName == null) {
            String string;
            String it;
            LOG.info("Failed to read upcoming feature store name from Zookeeper, look for old values...");
            String string2 = this.getZookeeperService().getZookeeperString("/just/search/ltr/featureStoreName/justSearchUpcomingFeatureStore");
            if (string2 != null) {
                String string3;
                it = string3 = string2;
                boolean bl = false;
                LOG.info("Old value for upcomingFeaturesStoreName found, store it in Zookeeper.");
                this.getZookeeperService().storeUpcomingFeatureStoreName(it);
                string = string3;
            } else {
                string = null;
            }
            currentUpcomingFeaturesStoreName = string;
            String string4 = this.getZookeeperService().getZookeeperString("/just/search/ltr/modelStoreName/justSearchModel");
            if (string4 != null) {
                it = string4;
                boolean bl = false;
                LOG.info("Old value for modelStoreName found, store it in Zookeeper.");
                this.getZookeeperService().storeModelName(it);
            }
            this.getZookeeperService().deleteNode("/just/search/ltr");
        }
        if (featureStoreWasUpdated = this.updateLTRFeatureDefinitions(currentUpcomingFeaturesStoreName, newUpcomingFeatureStoreName = "justSearchFeatures_" + LocalDateTime.now().format(dateFormatter))) {
            this.getZookeeperService().storeUpcomingFeatureStoreName(newUpcomingFeatureStoreName);
        }
    }

    public void uploadLTRModel(@NotNull LTRModel ltrModel) {
        Intrinsics.checkNotNullParameter((Object)ltrModel, (String)"ltrModel");
        Iterable $this$forEach$iv = this.allSolrClients;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SolrClient it = (SolrClient)element$iv;
            boolean bl = false;
            try {
                it.deleteLTRModel(ltrModel.getName());
                it.uploadLTRModel(ltrModel);
            }
            catch (Exception exp) {
                LOG.error("Failed to upload LTR model to SOLR '" + it.getCommonCoreUrl() + "'", (Throwable)exp);
                throw exp;
            }
        }
    }

    public void deleteLTRModel(@NotNull String model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        boolean successfullyDeleted = false;
        successfullyDeleted = true;
        Iterable $this$forEach$iv = this.allSolrClients;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SolrClient it = (SolrClient)element$iv;
            boolean bl = false;
            try {
                it.deleteLTRModel(model);
            }
            catch (Exception exp) {
                LOG.error("Failed to delete LTR model '" + model + "' from following SOLR server '" + it.getCommonCoreUrl() + "'", (Throwable)exp);
                successfullyDeleted = false;
            }
        }
        if (!successfullyDeleted) {
            throw new IllegalStateException("Failed to delete LTR model from all servers.".toString());
        }
    }

    public void deleteAllLTRModelsAndFeatures() {
        boolean successfullyDeleted = false;
        successfullyDeleted = true;
        Iterable $this$forEach$iv = this.allSolrClients;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SolrClient it = (SolrClient)element$iv;
            boolean bl = false;
            try {
                it.deleteAllLTRModelsAndFeatures();
            }
            catch (Exception exp) {
                LOG.error("Failed to delete all LTR models and features from following SOLR server '" + it.getCommonCoreUrl() + "'", (Throwable)exp);
                successfullyDeleted = false;
            }
        }
        if (!successfullyDeleted) {
            throw new IllegalStateException("Failed to delete all LTR models and features from all servers.".toString());
        }
    }

    private boolean areFeatureStoresUpToDate(String storeName, LTRFeatureConfiguration ltrFeatureConfig) {
        CharSequence charSequence = storeName;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        List expectedFeatureDefinition = LTRFeatureDefinition.Companion.createFeatureDefinitions(storeName, ltrFeatureConfig);
        Iterable $this$forEach$iv = this.allSolrClients;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SolrClient it = (SolrClient)element$iv;
            boolean bl = false;
            try {
                List currentFeatureDefinitions = it.ltrFeatureDefinitions(storeName);
                if (Intrinsics.areEqual((Object)currentFeatureDefinitions, (Object)expectedFeatureDefinition)) continue;
                return false;
            }
            catch (Exception exp) {
                LOG.error("Failed to check if feature definitions are up to date", (Throwable)exp);
                return false;
            }
        }
        return true;
    }

    private boolean updateLTRFeatureDefinitions(String currentStoreName, String newStoreName) {
        LTRFeatureConfiguration ltrFeatureConfiguration = this.getToroAPI().getLTRFeatureConfiguration();
        boolean areFeatureStoresUpToDate = this.areFeatureStoresUpToDate(currentStoreName, ltrFeatureConfiguration);
        if (areFeatureStoresUpToDate) {
            LOG.info("Solr LTR features '" + currentStoreName + "' are already up to date. Update will be skipped.");
            return false;
        }
        List newFeatureDefinition = LTRFeatureDefinition.Companion.createFeatureDefinitions(newStoreName, ltrFeatureConfiguration);
        Iterable $this$forEach$iv = this.allSolrClients;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SolrClient it = (SolrClient)element$iv;
            boolean bl = false;
            it.deleteLTRFeatureDefinitions(newStoreName);
            it.uploadLTRFeatureDefinitions(newFeatureDefinition);
        }
        return true;
    }

    private static final Unit initFeatureDefinitions$lambda$1(Solrs this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        LOG.info("Initializing LTR feature definitions to SOLR");
        this$0.updateUpcomingFeatureStore();
        LOG.info("LTR feature definitions to SOLR initialized.");
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
        dateFormatter = DateTimeFormatter.ofPattern("yyMMddHHmmss");
    }
}

