/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.searchltr.solr;

import de.justsoftware.searchltr.solr.SolrClient;
import de.justsoftware.searchltr.solr.Solrs;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lde/justsoftware/searchltr/solr/SolrHealthIndicator;", "Lorg/springframework/boot/actuate/health/AbstractHealthIndicator;", "solrs", "Lde/justsoftware/searchltr/solr/Solrs;", "<init>", "(Lde/justsoftware/searchltr/solr/Solrs;)V", "doHealthCheck", "", "builder", "Lorg/springframework/boot/actuate/health/Health$Builder;", "search-ltr"})
@SourceDebugExtension(value={"SMAP\nSolrHealthIndicator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolrHealthIndicator.kt\nde/justsoftware/searchltr/solr/SolrHealthIndicator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,33:1\n1863#2,2:34\n*S KotlinDebug\n*F\n+ 1 SolrHealthIndicator.kt\nde/justsoftware/searchltr/solr/SolrHealthIndicator\n*L\n21#1:34,2\n*E\n"})
public class SolrHealthIndicator
extends AbstractHealthIndicator {
    @NotNull
    private final Solrs solrs;

    public SolrHealthIndicator(@NotNull Solrs solrs) {
        Intrinsics.checkNotNullParameter((Object)solrs, (String)"solrs");
        super("Solr ping health check failed");
        this.solrs = solrs;
    }

    protected void doHealthCheck(@NotNull Health.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Iterator iterator = ((Iterable)this.solrs.getAllSolrClients()).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            SolrClient client = (SolrClient)iterator.next();
            Health.Builder builder2 = index == 0 ? builder.withDetail("leader", (Object)client.getCommonCoreUrl()) : builder.withDetail("replica" + (index - 1), (Object)client.getCommonCoreUrl());
        }
        try {
            Iterable $this$forEach$iv = this.solrs.getAllSolrClients();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SolrClient it = (SolrClient)element$iv;
                boolean bl = false;
                if (it.ping()) continue;
                builder.status(Status.DOWN);
                return;
            }
            builder.status(Status.UP);
        }
        catch (Exception e) {
            builder.status(Status.DOWN).withDetail("error", (Object)e.getMessage());
        }
    }
}

