/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.searchltr.persistence;

import de.justsoftware.searchltr.persistence.DBSearchResult;
import de.justsoftware.searchltr.persistence.DBSearchResultId;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bg\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH'J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH'J$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\u0006\u0010\u0014\u001a\u00020\u0015H'J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\rH'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001a\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/searchltr/persistence/SearchResultRepository;", "Lorg/springframework/data/jpa/repository/JpaRepository;", "Lde/justsoftware/searchltr/persistence/DBSearchResult;", "Lde/justsoftware/searchltr/persistence/DBSearchResultId;", "setClicked", "", "queryId", "Ljava/util/UUID;", "resultId", "", "findUnprocessedQueryId", "Lorg/springframework/data/domain/Page;", "minAgeTimestamp", "Ljava/time/Instant;", "pageable", "Lorg/springframework/data/domain/Pageable;", "findByQueryIdIn", "", "queryIds", "", "sort", "Lorg/springframework/data/domain/Sort;", "findByQueryIds", "findByProcessedTrueAndRelevanceNotNull", "deleteBySearchTimeBefore", "beforeDate", "search-ltr"})
@SourceDebugExtension(value={"SMAP\nSearchResultRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchResultRepository.kt\nde/justsoftware/searchltr/persistence/SearchResultRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1368#2:64\n1454#2,5:65\n*S KotlinDebug\n*F\n+ 1 SearchResultRepository.kt\nde/justsoftware/searchltr/persistence/SearchResultRepository\n*L\n49#1:64\n49#1:65,5\n*E\n"})
public interface SearchResultRepository
extends JpaRepository<DBSearchResult, DBSearchResultId> {
    @Modifying
    @Query(value="\n        UPDATE DBSearchResult sr\n        SET sr.clicked = true\n        WHERE sr.queryId = :queryId\n        AND sr.resultId = :resultId\n        ")
    public void setClicked(@NotNull UUID var1, @NotNull String var2);

    @Query(value="\n        SELECT DISTINCT(sr.queryId)\n        FROM DBSearchResult sr\n        WHERE sr.processed = false\n        AND sr.searchTime < :minAgeTimestamp\n        ORDER BY sr.queryId\n        ")
    @NotNull
    public Page<UUID> findUnprocessedQueryId(@NotNull Instant var1, @NotNull Pageable var2);

    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="updateSyncDateByChatIds(chatIds, syncDate)", imports={}))
    @NotNull
    public List<DBSearchResult> findByQueryIdIn(@NotNull Iterable<UUID> var1, @NotNull Sort var2);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public List<DBSearchResult> findByQueryIds(@NotNull Iterable<UUID> queryIds) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(queryIds, (String)"queryIds");
        Iterable $this$flatMap$iv = CollectionsKt.chunked(queryIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            Iterable iterable2 = it;
            String[] stringArray = new String[]{"queryId", "resultPosition"};
            Sort sort = Sort.by((String[])stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"by(...)");
            Iterable list$iv$iv = this.findByQueryIdIn(iterable2, sort);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public Page<DBSearchResult> findByProcessedTrueAndRelevanceNotNull(@NotNull Pageable var1);

    @Modifying
    @Query(value="\n        DELETE FROM DBSearchResult sr\n        WHERE sr.searchTime < :beforeDate\n        ")
    @Transactional
    public void deleteBySearchTimeBefore(@NotNull Instant var1);
}

