/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.tenant;

import de.justsoftware.news.domain.settings.Settings;
import de.justsoftware.news.domain.settings.SettingsRepo;
import de.justsoftware.news.domain.tenant.Tenant;
import de.justsoftware.news.domain.tenant.TenantRepo;
import de.justsoftware.news.id.TenantId;
import de.justsoftware.news.util.Unauthorized;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0017J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\n\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/justsoftware/news/domain/tenant/TenantService;", "", "tenantRepo", "Lde/justsoftware/news/domain/tenant/TenantRepo;", "settingsRepo", "Lde/justsoftware/news/domain/settings/SettingsRepo;", "<init>", "(Lde/justsoftware/news/domain/tenant/TenantRepo;Lde/justsoftware/news/domain/settings/SettingsRepo;)V", "delete", "Lde/justsoftware/news/id/TenantId;", "tenantId", "findById", "Lde/justsoftware/news/domain/tenant/Tenant;", "upsert", "tenant", "news-service"})
public class TenantService {
    @NotNull
    private final TenantRepo tenantRepo;
    @NotNull
    private final SettingsRepo settingsRepo;

    public TenantService(@NotNull TenantRepo tenantRepo, @NotNull SettingsRepo settingsRepo) {
        Intrinsics.checkNotNullParameter((Object)tenantRepo, (String)"tenantRepo");
        Intrinsics.checkNotNullParameter((Object)settingsRepo, (String)"settingsRepo");
        this.tenantRepo = tenantRepo;
        this.settingsRepo = settingsRepo;
    }

    @Unauthorized
    @NotNull
    public TenantId delete(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.tenantRepo.deleteById((Object)tenantId);
        return tenantId;
    }

    @Unauthorized
    @Nullable
    public Tenant findById(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return (Tenant)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.tenantRepo), (Object)tenantId);
    }

    @Transactional
    @Unauthorized
    @NotNull
    public Tenant upsert(@NotNull Tenant tenant) {
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        this.tenantRepo.findById((Object)tenant.getId()).ifPresentOrElse(arg_0 -> TenantService.upsert$lambda$1(arg_0 -> TenantService.upsert$lambda$0(this, tenant, arg_0), arg_0), () -> TenantService.upsert$lambda$2(this, tenant));
        return tenant;
    }

    private static final Unit upsert$lambda$0(TenantService this$0, Tenant $tenant, Tenant it) {
        this$0.tenantRepo.save((Object)$tenant);
        return Unit.INSTANCE;
    }

    private static final void upsert$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void upsert$lambda$2(TenantService this$0, Tenant $tenant) {
        this$0.tenantRepo.insert($tenant.getId());
        Settings defaultSettings = new Settings($tenant.getId(), false, false, 6, null);
        this$0.settingsRepo.insert(defaultSettings.getTenantId(), defaultSettings.getAllMayReadSubscriptionProfiles(), defaultSettings.getAllowAdditionalInfoInMailNotification());
    }
}

