/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.subscription.managed;

import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.ChannelAction;
import de.justsoftware.news.domain.channel.ChannelRepo;
import de.justsoftware.news.domain.subscription.SubscriptionRepoWrapper;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscription;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionAdd;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionChanges;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionRepo;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionService;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionType;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionUpdate;
import de.justsoftware.news.events.GroupDeletedEvent;
import de.justsoftware.news.events.ProfileDeletedEvent;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.ManagedSubscriptionId;
import de.justsoftware.news.id.UserId;
import de.justsoftware.news.util.Unauthorized;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J*\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00110\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001dH\u0017J\u0018\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionService;", "", "channelRepo", "Lde/justsoftware/news/domain/channel/ChannelRepo;", "managedSubscriptionRepo", "Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionRepo;", "subscriptionRepoWrapper", "Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;", "<init>", "(Lde/justsoftware/news/domain/channel/ChannelRepo;Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionRepo;Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;)V", "getByChannelIdAndUserId", "Lde/justsoftware/news/domain/subscription/managed/ManagedSubscription;", "channelId", "Lde/justsoftware/news/id/ChannelId;", "userId", "Lde/justsoftware/news/id/UserId;", "getForChannelIds", "", "channelIds", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "update", "Lde/justsoftware/news/domain/channel/Channel;", "changes", "Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionChanges;", "deleteManagedSubscriptions", "", "event", "Lde/justsoftware/news/events/ProfileDeletedEvent;", "Lde/justsoftware/news/events/GroupDeletedEvent;", "createChannelSubscriptions", "origin", "newType", "Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionType;", "Companion", "news-service"})
@SourceDebugExtension(value={"SMAP\nManagedSubscriptionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManagedSubscriptionService.kt\nde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1557#2:103\n1628#2,3:104\n1557#2:107\n1628#2,2:108\n774#2:110\n865#2,2:111\n1630#2:113\n1557#2:114\n1628#2,3:115\n1863#2,2:118\n1557#2:120\n1628#2,3:121\n1557#2:124\n1628#2,2:125\n1630#2:128\n1557#2:129\n1628#2,3:130\n1#3:127\n*S KotlinDebug\n*F\n+ 1 ManagedSubscriptionService.kt\nde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionService\n*L\n39#1:103\n39#1:104,3\n44#1:107\n44#1:108,2\n44#1:110\n44#1:111,2\n44#1:113\n51#1:114\n51#1:115,3\n53#1:118,2\n57#1:120\n57#1:121,3\n58#1:124\n58#1:125,2\n58#1:128\n71#1:129\n71#1:130,3\n*E\n"})
public class ManagedSubscriptionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChannelRepo channelRepo;
    @NotNull
    private final ManagedSubscriptionRepo managedSubscriptionRepo;
    @NotNull
    private final SubscriptionRepoWrapper subscriptionRepoWrapper;
    private static final Logger log = LoggerFactory.getLogger(ManagedSubscriptionService.class);

    public ManagedSubscriptionService(@NotNull ChannelRepo channelRepo, @NotNull ManagedSubscriptionRepo managedSubscriptionRepo, @NotNull SubscriptionRepoWrapper subscriptionRepoWrapper) {
        Intrinsics.checkNotNullParameter((Object)channelRepo, (String)"channelRepo");
        Intrinsics.checkNotNullParameter((Object)managedSubscriptionRepo, (String)"managedSubscriptionRepo");
        Intrinsics.checkNotNullParameter((Object)subscriptionRepoWrapper, (String)"subscriptionRepoWrapper");
        this.channelRepo = channelRepo;
        this.managedSubscriptionRepo = managedSubscriptionRepo;
        this.subscriptionRepoWrapper = subscriptionRepoWrapper;
    }

    @Unauthorized
    @NotNull
    public ManagedSubscription getByChannelIdAndUserId(@NotNull ChannelId channelId, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return (ManagedSubscription)CollectionsKt.first((Iterable)this.managedSubscriptionRepo.getByChannelIdAndUserId(channelId, userId));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<List<ManagedSubscription>> getForChannelIds(@NotNull List<ChannelId> channelIds, @NotNull AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (!authContext.mayManageAll((Collection)channelIds)) {
            Collection<String> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            Iterable iterable = channelIds;
            String string = authContext.getUser().toTypedString();
            Logger logger = log;
            boolean $i$f$map = false;
            void var5_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                ChannelId channelId = (ChannelId)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toTypedString());
            }
            collection = (List)destination$iv$iv;
            logger.warn("User '" + string + "' may not MANAGE at least one of '" + (List)collection + "'.");
            return CollectionsKt.emptyList();
        }
        Set subscriptions = this.managedSubscriptionRepo.getByChannelIdIn((Collection)channelIds);
        Iterable $this$map$iv = channelIds;
        boolean $i$f$map = false;
        Iterable destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            ChannelId bl = (ChannelId)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            Iterable $this$filter$iv = subscriptions;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                void channelId;
                ManagedSubscription it = (ManagedSubscription)element$iv$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getChannelId(), (Object)channelId)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            collection.add((List)destination$iv$iv3);
        }
        return (List)destination$iv$iv2;
    }

    @Transactional
    @NotNull
    public Channel update(@NotNull ManagedSubscriptionChanges changes, @NotNull AuthorizationContext authContext) {
        ManagedSubscription origin;
        ManagedSubscription it;
        ManagedSubscriptionUpdate add;
        Collection<UserId> collection;
        Object item$iv$iv2;
        Object $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkChannelAction(changes.getChannelId(), ChannelAction.MANAGE_SUBSCRIPTIONS);
        Channel channel = this.channelRepo.getByIdAndDeletedFalse(changes.getChannelId());
        Iterable iterable = changes.getAdds();
        Object object = (ItemId)channel.getTenantId();
        Object object2 = authContext;
        boolean $i$f$map = false;
        void var6_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv2 = iterator.next();
            ManagedSubscriptionAdd managedSubscriptionAdd = (ManagedSubscriptionAdd)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(add.getUserId());
        }
        collection = (List)destination$iv$iv;
        object2.checkAllReader((ItemId)object, (Collection)collection);
        Iterable $this$forEach$iv = changes.getAdds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ManagedSubscriptionAdd it2 = (ManagedSubscriptionAdd)element$iv;
            boolean bl = false;
            this.managedSubscriptionRepo.insert(ManagedSubscriptionId.Companion.random(), changes.getChannelId(), it2.getType(), it2.getUserId());
        }
        $this$forEach$iv = changes.getUpdates();
        object2 = this.managedSubscriptionRepo;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv2 = iterator.next();
            add = (ManagedSubscriptionUpdate)item$iv$iv2;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getId());
        }
        $this$map$iv = object2.findAllByIds((Collection)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object v0;
            block8: {
                item$iv$iv2 = iterator.next();
                it = (ManagedSubscription)item$iv$iv2;
                object2 = destination$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)origin.getChannelId(), (Object)changes.getChannelId())) {
                    boolean $i$a$-require-ManagedSubscriptionService$update$4$22 = false;
                    String $i$a$-require-ManagedSubscriptionService$update$4$22 = "Only changes for the same channel are allowed.";
                    throw new IllegalArgumentException($i$a$-require-ManagedSubscriptionService$update$4$22.toString());
                }
                Iterable iterable2 = changes.getUpdates();
                for (Object t : iterable2) {
                    ManagedSubscriptionUpdate it3 = (ManagedSubscriptionUpdate)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it3.getId(), (Object)origin.getId())) continue;
                    v0 = t;
                    break block8;
                }
                v0 = null;
            }
            Intrinsics.checkNotNull(v0);
            ManagedSubscriptionType newType = ((ManagedSubscriptionUpdate)v0).getType();
            Intrinsics.checkNotNull((Object)origin);
            this.createChannelSubscriptions(origin, newType);
            object2.add(ManagedSubscription.copy$default((ManagedSubscription)origin, null, null, (ManagedSubscriptionType)newType, null, (int)11, null));
        }
        List it4 = (List)destination$iv$iv;
        boolean $i$a$-let-ManagedSubscriptionService$update$62 = false;
        this.managedSubscriptionRepo.saveAll((Iterable)it4);
        $this$map$iv = this.managedSubscriptionRepo.findAllByIds((Collection)changes.getDeletes());
        $i$f$map = false;
        Iterable $i$a$-let-ManagedSubscriptionService$update$62 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            origin = (ManagedSubscription)item$iv$iv2;
            object2 = destination$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getChannelId(), (Object)changes.getChannelId())) {
                boolean bl3 = false;
                String string = "Only changes for the same channel are allowed.";
                throw new IllegalArgumentException(string.toString());
            }
            object2.add(it);
        }
        it = (List)destination$iv$iv;
        boolean bl = false;
        this.managedSubscriptionRepo.deleteAll((Iterable)it);
        return channel;
    }

    @EventListener
    public void deleteManagedSubscriptions(@NotNull ProfileDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.managedSubscriptionRepo.deleteByUserId((UserId)event.getProfileId());
    }

    @EventListener
    public void deleteManagedSubscriptions(@NotNull GroupDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.managedSubscriptionRepo.deleteByUserId((UserId)event.getUserGroupId());
    }

    private void createChannelSubscriptions(ManagedSubscription origin, ManagedSubscriptionType newType) {
        if (origin.getType() == newType || newType != ManagedSubscriptionType.NO_RECOMMENDATION) {
            return;
        }
        SubscriptionRepoWrapper.createPersonalSubscriptions$default((SubscriptionRepoWrapper)this.subscriptionRepoWrapper, (ChannelId)origin.getChannelId(), (UserId)origin.getUserId(), (boolean)false, (int)4, null);
    }
}

