/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.channel;

import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.connector.permission.PermissionKafkaProducer;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.ChannelAction;
import de.justsoftware.news.domain.channel.ChannelRepo;
import de.justsoftware.news.domain.channel.ChannelService$findAllByIds$;
import de.justsoftware.news.domain.channel.permission.ChannelPermissionRepo;
import de.justsoftware.news.domain.channel.permission.PermissionRole;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionRepo;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionType;
import de.justsoftware.news.events.ChannelCreatedEvent;
import de.justsoftware.news.events.ChannelUpdatedEvent;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.ManagedSubscriptionId;
import de.justsoftware.news.id.PermissionId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.id.TenantId;
import de.justsoftware.news.id.UserId;
import de.justsoftware.news.kafka.KafkaPublishOperation;
import de.justsoftware.news.util.TransactionSupport;
import de.justsoftware.news.util.Unauthorized;
import io.micrometer.observation.annotation.Observed;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.dialect.OracleDialect;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Observed
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0!2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\"\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130\u00192\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0019H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lde/justsoftware/news/domain/channel/ChannelService;", "", "channelRepo", "Lde/justsoftware/news/domain/channel/ChannelRepo;", "managedSubscriptionRepo", "Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionRepo;", "channelPermissionRepo", "Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;", "permissionKafkaProducer", "Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;", "transactionSupport", "Lde/justsoftware/news/util/TransactionSupport;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "dbDialect", "Lorg/springframework/data/relational/core/dialect/Dialect;", "<init>", "(Lde/justsoftware/news/domain/channel/ChannelRepo;Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionRepo;Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;Lde/justsoftware/news/util/TransactionSupport;Lorg/springframework/context/ApplicationEventPublisher;Lorg/springframework/data/relational/core/dialect/Dialect;)V", "create", "Lde/justsoftware/news/domain/channel/Channel;", "title", "", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "findAllSortedByTitle", "", "findById", "id", "Lde/justsoftware/news/id/ChannelId;", "getById", "getByIds", "", "ids", "", "update", "findAllByIds", "channelIds", "news-service"})
@SourceDebugExtension(value={"SMAP\nChannelService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChannelService.kt\nde/justsoftware/news/domain/channel/ChannelService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1557#2:114\n1628#2,3:115\n774#2:118\n865#2,2:119\n1053#2:121\n*S KotlinDebug\n*F\n+ 1 ChannelService.kt\nde/justsoftware/news/domain/channel/ChannelService\n*L\n79#1:114\n79#1:115,3\n80#1:118\n80#1:119,2\n111#1:121\n*E\n"})
public class ChannelService {
    @NotNull
    private final ChannelRepo channelRepo;
    @NotNull
    private final ManagedSubscriptionRepo managedSubscriptionRepo;
    @NotNull
    private final ChannelPermissionRepo channelPermissionRepo;
    @NotNull
    private final PermissionKafkaProducer permissionKafkaProducer;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final Dialect dbDialect;

    public ChannelService(@NotNull ChannelRepo channelRepo, @NotNull ManagedSubscriptionRepo managedSubscriptionRepo, @NotNull ChannelPermissionRepo channelPermissionRepo, @NotNull PermissionKafkaProducer permissionKafkaProducer, @NotNull TransactionSupport transactionSupport, @NotNull ApplicationEventPublisher eventPublisher, @NotNull Dialect dbDialect) {
        Intrinsics.checkNotNullParameter((Object)channelRepo, (String)"channelRepo");
        Intrinsics.checkNotNullParameter((Object)managedSubscriptionRepo, (String)"managedSubscriptionRepo");
        Intrinsics.checkNotNullParameter((Object)channelPermissionRepo, (String)"channelPermissionRepo");
        Intrinsics.checkNotNullParameter((Object)permissionKafkaProducer, (String)"permissionKafkaProducer");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)dbDialect, (String)"dbDialect");
        this.channelRepo = channelRepo;
        this.managedSubscriptionRepo = managedSubscriptionRepo;
        this.channelPermissionRepo = channelPermissionRepo;
        this.permissionKafkaProducer = permissionKafkaProducer;
        this.transactionSupport = transactionSupport;
        this.eventPublisher = eventPublisher;
        this.dbDialect = dbDialect;
    }

    @Transactional
    @NotNull
    public Channel create(@NotNull String title, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkCreateChannel();
        ChannelId channelId = ChannelId.Companion.random();
        Instant now = Instant.now();
        ChannelRepo channelRepo = this.channelRepo;
        String string = ((Object)StringsKt.trim((CharSequence)title)).toString();
        TenantId tenantId = authContext.getTenantId();
        Intrinsics.checkNotNull((Object)now);
        Instant instant = now;
        Instant instant2 = now;
        ProfileId profileId = authContext.getUser();
        ChannelRepo.insert$default((ChannelRepo)channelRepo, (ChannelId)channelId, (String)string, (TenantId)tenantId, (Instant)instant2, (Instant)instant, (boolean)false, (ProfileId)profileId, (int)32, null);
        Channel channel = this.channelRepo.getByIdAndDeletedFalse(channelId);
        this.channelPermissionRepo.insert(PermissionId.Companion.random(), channel.getId(), (UserId)authContext.getUser(), PermissionRole.MANAGER);
        this.managedSubscriptionRepo.insert(ManagedSubscriptionId.Companion.random(), channelId, ManagedSubscriptionType.RECOMMENDED, (UserId)authContext.getUser());
        this.transactionSupport.afterCommit(() -> ChannelService.create$lambda$0(this, channel, authContext));
        return channel;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Channel> findAllSortedByTitle(@NotNull AuthorizationContext authContext) {
        void $this$filterTo$iv$iv;
        Channel it;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        List tenantChannels = this.dbDialect instanceof OracleDialect ? this.channelRepo.getByTenantIdAndDeletedFalseOrderByTitleAscOracle(authContext.getTenantId()) : this.channelRepo.getByTenantIdAndDeletedFalseOrderByTitleAsc(authContext.getTenantId());
        Iterable iterable = tenantChannels;
        AuthorizationContext authorizationContext = authContext;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Channel channel = (Channel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List readableChannels = authorizationContext.filterReadable((Collection)((List)destination$iv$iv));
        Iterable $this$filter$iv = tenantChannels;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Channel)element$iv$iv;
            boolean bl = false;
            if (!readableChannels.contains(it.getId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public Channel findById(@NotNull ChannelId id, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkRead((ItemId)id);
        return (Channel)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.channelRepo), (Object)id);
    }

    @NotNull
    public Channel getById(@NotNull ChannelId id, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkRead((ItemId)id);
        return this.channelRepo.getByIdAndDeletedFalse(id);
    }

    @NotNull
    public Set<Channel> getByIds(@NotNull Collection<ChannelId> ids, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        List readable = authContext.filterReadable(ids);
        return this.channelRepo.getByIdInAndDeletedFalse((Collection)readable);
    }

    @Transactional
    @NotNull
    public Channel update(@NotNull ChannelId id, @NotNull String title, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkChannelAction(id, ChannelAction.RENAME);
        String string = ((Object)StringsKt.trim((CharSequence)title)).toString();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.channelRepo.updateTitle(id, string, instant, authContext.getUser());
        this.transactionSupport.afterCommit(() -> ChannelService.update$lambda$3(this, id));
        return this.channelRepo.getByIdAndDeletedFalse(id);
    }

    @Unauthorized
    @NotNull
    public List<Channel> findAllByIds(@NotNull List<ChannelId> channelIds) {
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        Iterable $this$sortedBy$iv = ChannelRepo.findAllByDeletedAndIdIn$default((ChannelRepo)this.channelRepo, (boolean)false, channelIds, (int)1, null);
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new findAllByIds$$inlined$sortedBy$1(channelIds)));
    }

    private static final Unit create$lambda$0(ChannelService this$0, Channel $channel, AuthorizationContext $authContext) {
        KafkaPublishOperation[] kafkaPublishOperationArray = new KafkaPublishOperation[]{this$0.permissionKafkaProducer.publishChannel($channel), this$0.permissionKafkaProducer.addPermission((ItemId)$channel.getId(), (UserId)$authContext.getUser(), PermissionRole.MANAGER)};
        KafkaPublishOperation.waitForCompletion$default((KafkaPublishOperation)new KafkaPublishOperation(kafkaPublishOperationArray), null, (int)1, null);
        this$0.eventPublisher.publishEvent((ApplicationEvent)new ChannelCreatedEvent($channel.getId()));
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$3(ChannelService this$0, ChannelId $id) {
        this$0.eventPublisher.publishEvent((ApplicationEvent)new ChannelUpdatedEvent($id));
        return Unit.INSTANCE;
    }
}

