/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.attachment;

import de.justsoftware.news.domain.attachment.AttachmentType;
import de.justsoftware.news.id.DocumentId;
import de.justsoftware.news.id.DriveFileReferenceId;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.annotation.Id;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u0018\u001a\u00020\u0019J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\nH\u00c6\u0003JE\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020\nH\u00d6\u0001J\t\u0010%\u001a\u00020\u0007H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016\u00a8\u0006&"}, d2={"Lde/justsoftware/news/domain/attachment/Attachment;", "", "id", "Lde/justsoftware/news/id/DocumentId;", "itemId", "Lde/justsoftware/news/id/DriveFileReferenceId;", "mimeType", "", "name", "fileSize", "", "position", "<init>", "(Lde/justsoftware/news/id/DocumentId;Lde/justsoftware/news/id/DriveFileReferenceId;Ljava/lang/String;Ljava/lang/String;II)V", "getId", "()Lde/justsoftware/news/id/DocumentId;", "getItemId", "()Lde/justsoftware/news/id/DriveFileReferenceId;", "getMimeType", "()Ljava/lang/String;", "getName", "getFileSize", "()I", "getPosition", "getAttachmentType", "Lde/justsoftware/news/domain/attachment/AttachmentType;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "news-service"})
public final class Attachment {
    @Id
    @NotNull
    private final DocumentId id;
    @NotNull
    private final DriveFileReferenceId itemId;
    @NotNull
    private final String mimeType;
    @NotNull
    private final String name;
    private final int fileSize;
    private final int position;

    public Attachment(@NotNull DocumentId id, @NotNull DriveFileReferenceId itemId, @NotNull String mimeType, @NotNull String name, int fileSize, int position) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.id = id;
        this.itemId = itemId;
        this.mimeType = mimeType;
        this.name = name;
        this.fileSize = fileSize;
        this.position = position;
    }

    @NotNull
    public final DocumentId getId() {
        return this.id;
    }

    @NotNull
    public final DriveFileReferenceId getItemId() {
        return this.itemId;
    }

    @NotNull
    public final String getMimeType() {
        return this.mimeType;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getFileSize() {
        return this.fileSize;
    }

    public final int getPosition() {
        return this.position;
    }

    @NotNull
    public final AttachmentType getAttachmentType() {
        String string = StringsKt.substringBefore$default((String)this.mimeType, (String)"/", null, (int)2, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return switch (string) {
            case "image" -> AttachmentType.IMAGE;
            case "text" -> AttachmentType.TEXT;
            case "video" -> AttachmentType.VIDEO;
            default -> AttachmentType.OTHER;
        };
    }

    @NotNull
    public final DocumentId component1() {
        return this.id;
    }

    @NotNull
    public final DriveFileReferenceId component2() {
        return this.itemId;
    }

    @NotNull
    public final String component3() {
        return this.mimeType;
    }

    @NotNull
    public final String component4() {
        return this.name;
    }

    public final int component5() {
        return this.fileSize;
    }

    public final int component6() {
        return this.position;
    }

    @NotNull
    public final Attachment copy(@NotNull DocumentId id, @NotNull DriveFileReferenceId itemId, @NotNull String mimeType, @NotNull String name, int fileSize, int position) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new Attachment(id, itemId, mimeType, name, fileSize, position);
    }

    public static /* synthetic */ Attachment copy$default(Attachment attachment, DocumentId documentId, DriveFileReferenceId driveFileReferenceId, String string, String string2, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            documentId = attachment.id;
        }
        if ((n3 & 2) != 0) {
            driveFileReferenceId = attachment.itemId;
        }
        if ((n3 & 4) != 0) {
            string = attachment.mimeType;
        }
        if ((n3 & 8) != 0) {
            string2 = attachment.name;
        }
        if ((n3 & 0x10) != 0) {
            n = attachment.fileSize;
        }
        if ((n3 & 0x20) != 0) {
            n2 = attachment.position;
        }
        return attachment.copy(documentId, driveFileReferenceId, string, string2, n, n2);
    }

    @NotNull
    public String toString() {
        return "Attachment(id=" + this.id + ", itemId=" + this.itemId + ", mimeType=" + this.mimeType + ", name=" + this.name + ", fileSize=" + this.fileSize + ", position=" + this.position + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.itemId.hashCode();
        result = result * 31 + this.mimeType.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + Integer.hashCode(this.fileSize);
        result = result * 31 + Integer.hashCode(this.position);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Attachment)) {
            return false;
        }
        Attachment attachment = (Attachment)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)attachment.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.itemId, (Object)attachment.itemId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.mimeType, (Object)attachment.mimeType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)attachment.name)) {
            return false;
        }
        if (this.fileSize != attachment.fileSize) {
            return false;
        }
        return this.position == attachment.position;
    }
}

