/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.people.service;

import de.justsoftware.mobile.gateway.people.model.remote.LegacyProfileApiAttributes;
import de.justsoftware.mobile.gateway.people.model.remote.LegacyProfileApiConfiguration;
import de.justsoftware.mobile.gateway.people.model.remote.LegacyProfileApiProfile;
import de.justsoftware.mobile.gateway.people.model.remote.LegacyProfileApiSection;
import de.justsoftware.mobile.gateway.people.model.remote.LegacyProfilePersonalData;
import de.justsoftware.mobile.gateway.people.service.LegacyProfileApiGatewayService;
import de.justsoftware.mobile.gateway.people.service.LegacyProfileApiGatewayService$deleteAttributeBlock$;
import de.justsoftware.mobile.gateway.people.service.LegacyProfileApiGatewayService$getPersonalData$;
import de.justsoftware.mobile.gateway.people.service.LegacyProfileApiGatewayService$getProfileAttributeSection$;
import de.justsoftware.mobile.gateway.people.service.LegacyProfileApiGatewayService$updatePersonalData$;
import de.justsoftware.mobile.gateway.util.UrisKt;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.reactive.function.client.WebClient;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u0000 &2\u00020\u0001:\u0001&B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u0003H\u0012J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u0003H\u0012J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u0003H\u0012J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u0003H\u0012J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u0003H\u0012J\u0018\u0010$\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0012J \u0010%\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lde/justsoftware/mobile/gateway/people/service/LegacyProfileApiGatewayService;", "", "toroBaseUrl", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "getProfile", "Lde/justsoftware/mobile/gateway/people/model/remote/LegacyProfileApiProfile;", "userId", "getProfileAttributes", "Lde/justsoftware/mobile/gateway/people/model/remote/LegacyProfileApiAttributes;", "getProfileAttributeSection", "Lde/justsoftware/mobile/gateway/people/model/remote/LegacyProfileApiSection;", "sectionName", "getProfileConfiguration", "Lde/justsoftware/mobile/gateway/people/model/remote/LegacyProfileApiConfiguration;", "updateUserImage", "image", "Lorg/springframework/web/multipart/MultipartFile;", "deleteUserImage", "getPersonalData", "Lde/justsoftware/mobile/gateway/people/model/remote/LegacyProfilePersonalData;", "updatePersonalData", "personalData", "deleteAttributeBlock", "", "blockIndex", "", "profileUri", "Ljava/net/URI;", "profileConfigurationUri", "updateUserImageUri", "deleteUserImageUri", "personalDataUri", "getProfileAttributeSectionUri", "deleteAttributeBlockUri", "Companion", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nLegacyProfileApiGatewayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyProfileApiGatewayService.kt\nde/justsoftware/mobile/gateway/people/service/LegacyProfileApiGatewayService\n+ 2 WebClients.kt\nde/justsoftware/mobile/gateway/util/WebClientsKt\n*L\n1#1,89:1\n48#2:90\n48#2:91\n48#2:92\n64#2:93\n76#2:94\n85#2:95\n48#2:96\n82#2:97\n85#2:98\n*S KotlinDebug\n*F\n+ 1 LegacyProfileApiGatewayService.kt\nde/justsoftware/mobile/gateway/people/service/LegacyProfileApiGatewayService\n*L\n26#1:90\n32#1:91\n35#1:92\n41#1:93\n41#1:94\n48#1:95\n51#1:96\n57#1:97\n60#1:98\n*E\n"})
public class LegacyProfileApiGatewayService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String toroBaseUrl;
    @NotNull
    private final WebClient webClient;
    @NotNull
    private static final String PROFILE_BASE = "/profile/api/v1";
    @NotNull
    private static final String UPDATE_IMAGE_PARAMETER_NAME = "image";

    public LegacyProfileApiGatewayService(@Value(value="${just.toro.internal.baseurl}") @NotNull String toroBaseUrl, @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)toroBaseUrl, (String)"toroBaseUrl");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.toroBaseUrl = toroBaseUrl;
        this.webClient = webClient;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LegacyProfileApiProfile getProfile(@NotNull String userId) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.profileUri(userId);
        boolean $i$f$get = false;
        return (LegacyProfileApiProfile)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    @NotNull
    public LegacyProfileApiAttributes getProfileAttributes(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        LegacyProfileApiAttributes legacyProfileApiAttributes = this.getProfile(userId).getProfileAttributes();
        if (legacyProfileApiAttributes == null) {
            legacyProfileApiAttributes = LegacyProfileApiAttributes.Companion.getEMPTY();
        }
        return legacyProfileApiAttributes;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LegacyProfileApiSection getProfileAttributeSection(@NotNull String userId, @NotNull String sectionName) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)sectionName, (String)"sectionName");
        WebClient webClient = this.webClient;
        URI uri$iv = this.getProfileAttributeSectionUri(userId, sectionName);
        boolean $i$f$get = false;
        return (LegacyProfileApiSection)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getProfileAttributeSection$$inlined$get$1((WebClient)$this$get$iv, uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LegacyProfileApiConfiguration getProfileConfiguration(@NotNull String userId) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.profileConfigurationUri(userId);
        boolean $i$f$get = false;
        return (LegacyProfileApiConfiguration)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LegacyProfileApiProfile updateUserImage(@NotNull String userId, @NotNull MultipartFile image) {
        void name$iv;
        void uri$iv;
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)image, (String)UPDATE_IMAGE_PARAMETER_NAME);
        WebClient webClient = this.webClient;
        URI uRI = this.updateUserImageUri(userId);
        String string = UPDATE_IMAGE_PARAMETER_NAME;
        boolean $i$f$post = false;
        return (LegacyProfileApiProfile)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LegacyProfileApiProfile deleteUserImage(@NotNull String userId) {
        void $this$delete$iv;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.deleteUserImageUri(userId);
        boolean $i$f$delete = false;
        return (LegacyProfileApiProfile)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LegacyProfilePersonalData getPersonalData(@NotNull String userId) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.personalDataUri(userId);
        boolean $i$f$get = false;
        return (LegacyProfilePersonalData)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getPersonalData$$inlined$get$1((WebClient)$this$get$iv, uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LegacyProfilePersonalData updatePersonalData(@NotNull String userId, @NotNull LegacyProfilePersonalData personalData) {
        void $this$put$iv;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)personalData, (String)"personalData");
        WebClient webClient = this.webClient;
        URI uri$iv = this.personalDataUri(userId);
        boolean $i$f$put = false;
        return (LegacyProfilePersonalData)BuildersKt.runBlocking$default(null, (Function2)((Function2)new updatePersonalData$$inlined$put$1((WebClient)$this$put$iv, uri$iv, (Object)personalData, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void deleteAttributeBlock(@NotNull String userId, @NotNull String sectionName, int blockIndex) {
        void $this$delete$iv;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)sectionName, (String)"sectionName");
        WebClient webClient = this.webClient;
        URI uri$iv = this.deleteAttributeBlockUri(userId, sectionName, blockIndex);
        boolean $i$f$delete = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new deleteAttributeBlock$$inlined$delete$1((WebClient)$this$delete$iv, uri$iv, null)), (int)1, null);
    }

    private URI profileUri(String userId) {
        return UrisKt.buildUri$default((String)(this.toroBaseUrl + "/profile/api/v1/" + userId), null, null, (int)6, null);
    }

    private URI profileConfigurationUri(String userId) {
        return UrisKt.buildUri$default((String)(this.toroBaseUrl + "/profile/api/v1/attributes/configuration/" + userId), null, null, (int)6, null);
    }

    private URI updateUserImageUri(String userId) {
        return UrisKt.buildUri$default((String)(this.toroBaseUrl + "/profile/api/v1/" + userId + "/image"), null, null, (int)6, null);
    }

    private URI deleteUserImageUri(String userId) {
        return UrisKt.buildUri$default((String)(this.toroBaseUrl + "/profile/api/v1/" + userId + "/image"), null, null, (int)6, null);
    }

    private URI personalDataUri(String userId) {
        return UrisKt.buildUri$default((String)(this.toroBaseUrl + "/profile/api/v1/" + userId + "/personal"), null, null, (int)6, null);
    }

    private URI getProfileAttributeSectionUri(String userId, String sectionName) {
        return UrisKt.buildUri$default((String)(this.toroBaseUrl + "/profile/api/v1/" + userId + "/attributes/" + sectionName), null, null, (int)6, null);
    }

    private URI deleteAttributeBlockUri(String userId, String sectionName, int blockIndex) {
        return UrisKt.buildUri$default((String)(this.toroBaseUrl + "/profile/api/v1/" + userId + "/attributes/" + sectionName + "/" + blockIndex), null, null, (int)6, null);
    }
}

