/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.common.service;

import de.justsoftware.mobile.gateway.common.service.HTMLSanitizer;
import de.justsoftware.mobile.gateway.common.service.JsoupHTMLSanitizer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Safelist;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lde/justsoftware/mobile/gateway/common/service/JsoupHTMLSanitizer;", "Lde/justsoftware/mobile/gateway/common/service/HTMLSanitizer;", "systemDomainPrefix", "", "<init>", "(Ljava/lang/String;)V", "sanitize", "html", "Companion", "mobile-gateway"})
public final class JsoupHTMLSanitizer
implements HTMLSanitizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String systemDomainPrefix;
    @NotNull
    private static String[] customAttributes;
    @NotNull
    private static Document.OutputSettings outputSettings;
    @NotNull
    private static final Safelist safelist;

    public JsoupHTMLSanitizer(@NotNull String systemDomainPrefix) {
        Intrinsics.checkNotNullParameter((Object)systemDomainPrefix, (String)"systemDomainPrefix");
        this.systemDomainPrefix = systemDomainPrefix;
    }

    @NotNull
    public String sanitize(@NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        String string = Jsoup.clean((String)html, (String)this.systemDomainPrefix, (Safelist)safelist, (Document.OutputSettings)outputSettings);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clean(...)");
        return string;
    }

    static {
        String[] stringArray = new String[]{"class", "contenteditable", "draggable", "focusable", "style", "translate"};
        customAttributes = stringArray;
        Document.OutputSettings outputSettings = new Document.OutputSettings().prettyPrint(false);
        Intrinsics.checkNotNullExpressionValue((Object)outputSettings, (String)"prettyPrint(...)");
        JsoupHTMLSanitizer.outputSettings = outputSettings;
        String[] stringArray2 = new String[]{"article", "button", "s"};
        Safelist safelist = Safelist.relaxed().preserveRelativeLinks(true).addTags(stringArray2);
        stringArray2 = new String[]{"app-profile-image-avatar", "app-prosemirror-drive-document", "app-prosemirror-drive-image", "app-prosemirror-drive-video", "app-prosemirror-internal-link", "app-prosemirror-person", "app-video-preview", "fa-icon", "mat-icon", "path", "svg", "video"};
        Safelist safelist2 = safelist.addTags(stringArray2);
        stringArray2 = new String[]{"target"};
        Safelist safelist3 = safelist2.addAttributes("a", stringArray2);
        stringArray2 = new String[]{"drive-doc-id", "file-type", "text", "type"};
        Safelist safelist4 = safelist3.addAttributes("app-prosemirror-drive-document", stringArray2);
        stringArray2 = new String[]{"id", "width", "height", "link", "text", "text-position"};
        Safelist safelist5 = safelist4.addAttributes("app-prosemirror-drive-image", stringArray2);
        stringArray2 = new String[]{"id", "width", "height", "title"};
        Safelist safelist6 = safelist5.addAttributes("app-prosemirror-drive-video", stringArray2);
        stringArray2 = new String[]{"anchorId", "id", "title", "type"};
        Safelist safelist7 = safelist6.addAttributes("app-prosemirror-internal-link", stringArray2);
        stringArray2 = new String[]{"profile-id", "description"};
        Safelist safelist8 = safelist7.addAttributes("app-prosemirror-person", stringArray2);
        stringArray2 = new String[]{"type", "title"};
        Safelist safelist9 = safelist8.addAttributes("button", stringArray2);
        stringArray2 = new String[]{"data-id"};
        Safelist safelist10 = safelist9.addAttributes("h1", stringArray2);
        stringArray2 = new String[]{"data-id"};
        Safelist safelist11 = safelist10.addAttributes("h2", stringArray2);
        stringArray2 = new String[]{"data-id"};
        Safelist safelist12 = safelist11.addAttributes("h3", stringArray2);
        stringArray2 = new String[]{"data-list"};
        Safelist safelist13 = safelist12.addAttributes("li", stringArray2);
        stringArray2 = new String[]{"role", "data-mat-icon-type"};
        Safelist safelist14 = safelist13.addAttributes("mat-icon", stringArray2);
        stringArray2 = new String[]{"currentColor", "d"};
        Safelist safelist15 = safelist14.addAttributes("path", stringArray2);
        stringArray2 = new String[]{"data-icon", "data-prefix", "role", "viewBox"};
        Safelist safelist16 = safelist15.addAttributes("svg", stringArray2);
        stringArray2 = new String[]{"playsinline", "poster", "preload"};
        Safelist safelist17 = safelist16.addAttributes("video", stringArray2);
        stringArray2 = customAttributes;
        Safelist safelist18 = safelist17.addAttributes(":all", Arrays.copyOf(stringArray2, stringArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)safelist18, (String)"addAttributes(...)");
        JsoupHTMLSanitizer.safelist = safelist18;
    }
}

