/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.business.usergroup.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import de.justsoftware.justimport.business.usergroup.UserGroupImportPublisher;
import de.justsoftware.justimport.business.usergroup.impl.UserGroupImportKafkaProducer;
import de.justsoftware.justimport.domain.model.common.TenantId;
import de.justsoftware.justimport.domain.model.profile.ProfileId;
import de.justsoftware.justimport.domain.model.usergroup.UserGroupId;
import de.justsoftware.justimport.persistence.model.DbUserGroup;
import de.justsoftware.justimport.persistence.model.ImportMethod;
import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.kafka.client.KafkaCleaningProducerState;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class UserGroupImportKafkaProducer
implements UserGroupImportPublisher {
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @VisibleForTesting
    static final String GROUP_TOPIC = "just.people.import.userGroup";
    @VisibleForTesting
    static final String MEMBER_TOPIC = "just.people.import.userGroupMembers";
    private static final Logger LOG = LoggerFactory.getLogger(UserGroupImportKafkaProducer.class);
    private final KafkaCleaningProducer<String, String> _kafkaProducer;

    public UserGroupImportKafkaProducer(KafkaCleaningProducer<String, String> producer) {
        this._kafkaProducer = producer;
    }

    private void logErrorCallback(RecordMetadata metadata, @Nullable Exception exception) {
        if (exception != null) {
            LOG.error("Could not publish group data to topic " + metadata.topic(), (Throwable)exception);
        }
    }

    public boolean publishImportedUserGroup(TenantId tenantId, UserGroupId userGroupId, String userGroupName, ImportMethod importMethod) {
        Optional json = this.groupToJsonString(tenantId, userGroupName, importMethod);
        if (json.isEmpty()) {
            LOG.error("Failed to generate json for user group {}", (Object)userGroupName);
            return false;
        }
        ProducerRecord record = Records.addGroupRecord((UserGroupId)userGroupId, (String)((String)json.get()));
        this.send(record);
        return true;
    }

    public void publishImportedUserGroup(DbUserGroup userGroup) {
        Optional json = this.groupToJsonString(userGroup);
        if (json.isEmpty()) {
            LOG.error("Failed to generate json for group {}", (Object)userGroup.getGroupId());
            return;
        }
        ProducerRecord record = Records.addGroupRecord((UserGroupId)userGroup.getGroupId(), (String)((String)json.get()));
        this.send(record);
    }

    public void publishDeletedUserGroup(UserGroupId groupId) {
        ProducerRecord record = Records.removeGroupRecord((UserGroupId)groupId);
        this.send(record);
    }

    public void publishAndCleanAllUserGroupMembers(UserGroupId userGroupId, Set<ProfileId> members, Consumer<Boolean> publishResult) {
        try (KafkaCleaningProducerState state = this._kafkaProducer.beginRefill(new String[]{"just.people.import.userGroupMembers"});){
            members.forEach(member -> this.publishImportedUserGroupMember(userGroupId, member, publishResult));
            state.finishRefill(key -> key.endsWith("@" + userGroupId.asString()));
        }
    }

    public void publishAddedUserGroupMember(UserGroupId userGroupId, ProfileId addedMemberId) {
        ProducerRecord record = Records.addMember((UserGroupId)userGroupId, (ProfileId)addedMemberId);
        this.send(record);
    }

    public void publishRemovedUserGroupMember(UserGroupId userGroupId, ProfileId removedMemberId) {
        ProducerRecord record = Records.removeMember((UserGroupId)userGroupId, (ProfileId)removedMemberId);
        this.send(record);
    }

    private void publishImportedUserGroupMember(UserGroupId userGroupId, ProfileId member, Consumer<Boolean> publishResult) {
        ProducerRecord record = Records.addMember((UserGroupId)userGroupId, (ProfileId)member);
        this.send(record);
        publishResult.accept(Boolean.TRUE);
    }

    private void send(ProducerRecord<String, String> record) {
        this._kafkaProducer.send(record, (arg_0, arg_1) -> this.logErrorCallback(arg_0, arg_1));
    }

    @Nonnull
    private Optional<String> groupToJsonString(DbUserGroup userGroup) {
        return this.groupToJsonString(new TenantId(userGroup.getTenantId()), userGroup.getName(), (ImportMethod)MoreObjects.firstNonNull((Object)userGroup.getImportMethod(), (Object)ImportMethod.UNKNOWN));
    }

    @Nonnull
    private Optional<String> groupToJsonString(TenantId tenantId, String userGroupName, ImportMethod importMethod) {
        try {
            ObjectNode groupValue = OBJECT_MAPPER.createObjectNode();
            groupValue.set("name", (JsonNode)TextNode.valueOf((String)userGroupName));
            groupValue.set("tenantId", (JsonNode)TextNode.valueOf((String)tenantId.asString()));
            groupValue.set("importMethod", (JsonNode)TextNode.valueOf((String)importMethod.toString()));
            return Optional.of(OBJECT_MAPPER.writeValueAsString((Object)groupValue));
        }
        catch (JsonProcessingException e) {
            LOG.error("Failed to create record for user group", (Throwable)e);
            return Optional.empty();
        }
    }
}

