/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.security;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.introspection.ReactiveOpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.introspection.SpringReactiveOpaqueTokenIntrospector;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@ParametersAreNonnullByDefault
@Service
public class ToroOpaqueTokenIntrospector
implements ReactiveOpaqueTokenIntrospector {
    public static final Duration CACHE_EXPIRATION_DURATION = Duration.ofMinutes(1L);
    private final AsyncLoadingCache<String, OAuth2AuthenticatedPrincipal> _tokenCache;

    public ToroOpaqueTokenIntrospector(@Value(value="${just.login.oauth2.resource.client_id}") String clientId, @Value(value="${just.login.oauth2.resource.client_secret}") String clientSecret, @Value(value="${just.login.oauth2.resource.check_token_endpoint}") String checkTokenEndpoint, @Value(value="${just.login.oauth2.resource.accessTokenCache.maxSize:1000}") int maxAccessTokenCacheSize) {
        SpringReactiveOpaqueTokenIntrospector introspector = new SpringReactiveOpaqueTokenIntrospector(checkTokenEndpoint, clientId, clientSecret);
        this._tokenCache = Caffeine.newBuilder().expireAfterWrite(CACHE_EXPIRATION_DURATION).maximumSize((long)maxAccessTokenCacheSize).buildAsync((arg_0, arg_1) -> ToroOpaqueTokenIntrospector.lambda$new$0((ReactiveOpaqueTokenIntrospector)introspector, arg_0, arg_1));
    }

    public Mono<OAuth2AuthenticatedPrincipal> introspect(String token) {
        return Mono.fromCompletionStage((CompletionStage)this._tokenCache.get((Object)token));
    }

    private static /* synthetic */ CompletableFuture lambda$new$0(ReactiveOpaqueTokenIntrospector introspector, String token, Executor executor) throws Exception {
        return introspector.introspect(token).toFuture();
    }
}

