/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.config;

import com.google.common.collect.ImmutableList;
import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import jakarta.servlet.Filter;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@ParametersAreNonnullByDefault
public class RestSecurityConfig {
    private static final String INTERNAL_API = "/internal/**";
    private static final String FILESYNC_API = "/sync/**";
    private static final String PUBLIC_LINK_API = "/s/**";
    private static final String UNAUTHENTICATED_API = "/api/unauthenticated/**";
    private static final String[] SWAGGER_RESOURCES = new String[]{"/swagger/**", "/configuration/**", "/swagger-resources/**", "/swagger-ui/**", "/webjars/**", "/v3/api-docs/**"};
    private static final OrRequestMatcher JWT_IGNORE_PATH_MATCHER = new OrRequestMatcher((List)ImmutableList.of((Object)new AntPathRequestMatcher("/internal/**"), (Object)new AntPathRequestMatcher("/sync/**"), (Object)new AntPathRequestMatcher("/s/**"), (Object)new AntPathRequestMatcher("/api/unauthenticated/**")));
    private static final OrRequestMatcher ALLOW_COOKIE_ONLY_AUTH = new OrRequestMatcher((List)ImmutableList.of((Object)new AntPathRequestMatcher("/api/previews/**"), (Object)new AntPathRequestMatcher("/api/documents/folder/*/zip"), (Object)new AntPathRequestMatcher("/api/documents/fileversion/*/download"), (Object)new AntPathRequestMatcher("/api/documents/*/download")));
    private final JwtAuthenticationProcessingFilter _jwtAuthenticationProcessingFilter;

    @Autowired
    public RestSecurityConfig(JwtAuthenticationProcessingFilter jwtAuthenticationProcessingFilter) {
        this._jwtAuthenticationProcessingFilter = jwtAuthenticationProcessingFilter;
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        this._jwtAuthenticationProcessingFilter.applyIgnoreFilterMatcher((RequestMatcher)JWT_IGNORE_PATH_MATCHER).applyAllowCookieOnlyVerificationMatcher((RequestMatcher)ALLOW_COOKIE_ONLY_AUTH);
        http.sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).exceptionHandling(Customizer.withDefaults()).anonymous(Customizer.withDefaults()).servletApi(Customizer.withDefaults()).headers(headers -> headers.cacheControl(Customizer.withDefaults())).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{INTERNAL_API, FILESYNC_API, PUBLIC_LINK_API, UNAUTHENTICATED_API})).permitAll().requestMatchers(SWAGGER_RESOURCES)).permitAll().anyRequest()).authenticated()).addFilterAfter((Filter)this._jwtAuthenticationProcessingFilter, AbstractPreAuthenticatedProcessingFilter.class).csrf(AbstractHttpConfigurer::disable);
        return (SecurityFilterChain)http.build();
    }
}

