/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.settings;

import de.justsoftware.drive.common.settings.model.SettingsBO;
import de.justsoftware.drive.common.tenant.model.TenantId;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;

@Mapper
@ParametersAreNonnullByDefault
public interface SettingsMapper {
    @Insert(value={"<script>\n    <if test=\"_databaseId == 'ORACLE'\">\n        MERGE INTO settings s\n        USING (SELECT #{tenantId} as tenant_id, #{publicLinksEnabled} as public_links_enabled FROM dual) t\n        ON (s.tenant_id = t.tenant_id)\n        WHEN MATCHED THEN\n          UPDATE SET s.public_links_enabled = t.public_links_enabled\n        WHEN NOT MATCHED THEN\n          INSERT (tenant_id, public_links_enabled)\n          VALUES (t.tenant_id, t.public_links_enabled)\n    </if>\n    <if test=\"_databaseId == 'POSTGRES'\">\n        INSERT INTO settings (tenant_id, public_links_enabled)\n            VALUES (#{tenantId}, #{publicLinksEnabled})\n            ON CONFLICT (tenant_id)\n            DO UPDATE SET public_links_enabled = #{publicLinksEnabled}\n    </if>\n</script>\n"})
    public void insert(SettingsBO var1);

    @Select(value={"SELECT * FROM settings WHERE tenant_id = #{tenantId}"})
    public SettingsBO getSettings(TenantId var1);

    @Select(value={"SELECT * FROM settings"})
    public List<SettingsBO> getAllSettings();
}

