/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.migration;

import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.persistence.item.ItemMapper;
import de.justsoftware.drive.persistence.migration.ItemMigrationMapper;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ParametersAreNonnullByDefault
public class ItemMigrationDAO {
    private static final Logger LOG = LoggerFactory.getLogger(ItemMigrationDAO.class);
    private final ItemMigrationMapper _mapper;
    private final ItemMapper _itemMapper;

    public ItemMigrationDAO(ItemMigrationMapper mapper, ItemMapper itemMapper) {
        this._mapper = mapper;
        this._itemMapper = itemMapper;
    }

    @Transactional
    public void migrate(ItemId originalId, ItemId migratedId) {
        this._mapper.migrateChange(originalId, migratedId);
        this._mapper.migrateItem(originalId, migratedId);
        this._mapper.migrateItemParent(originalId, migratedId);
        this._itemMapper.deleteItems(List.of(originalId));
    }
}

