/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.settings;

import de.justsoftware.drive.business.settings.SettingsService;
import de.justsoftware.drive.common.settings.model.SettingsBO;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.persistence.settings.SettingsDAO;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class SettingsServiceImpl
implements SettingsService {
    private final SettingsDAO _settingsDAO;

    @Autowired
    public SettingsServiceImpl(SettingsDAO settingsDAO) {
        this._settingsDAO = settingsDAO;
    }

    @CheckForNull
    public SettingsBO getSettings(TenantId tenantId) {
        return this._settingsDAO.getSettings(tenantId);
    }

    @Nonnull
    public List<SettingsBO> getAllSettings() {
        return this._settingsDAO.getAllSettings();
    }

    public SettingsBO insertSettings(SettingsBO settings) {
        this._settingsDAO.insert(settings);
        return this._settingsDAO.getSettings(settings.tenantId());
    }

    public boolean isPublicLinksEnabled(TenantId tenantId) {
        SettingsBO settings = this.getSettings(tenantId);
        return settings != null && settings.publicLinksEnabled();
    }
}

