/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.migration;

import de.justsoftware.drive.business.event.ItemVisibilitiesChangedEvent;
import de.justsoftware.drive.business.search.SolrIndexQueueProducer;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.persistence.migration.ItemMigrationDAO;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class ItemMigrationConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(ItemMigrationConsumer.class);
    private static final String TOPIC = "just.migration.item";
    private final ItemMigrationDAO _itemMigrationDAO;
    private final SolrIndexQueueProducer _indexQueueProducer;

    public ItemMigrationConsumer(ItemMigrationDAO attachmentDAO, SolrIndexQueueProducer indexQueueProducer) {
        this._itemMigrationDAO = attachmentDAO;
        this._indexQueueProducer = indexQueueProducer;
    }

    @KafkaListener(topics={"just.migration.item"}, containerFactory="itemIdItemIdConsumer", groupId="just.drive.ItemMigrationConsumer")
    public void listen(@Header(value="kafka_receivedMessageKey") ItemId originalId, @Payload ItemId migratedId) {
        try {
            this._itemMigrationDAO.migrate(originalId, migratedId);
            LOG.debug(String.format("Migrated ItemId from %s to %s", originalId, migratedId));
            this._indexQueueProducer.onItemVisibilitiesChanged(new ItemVisibilitiesChangedEvent(Set.of(migratedId)));
        }
        catch (IllegalArgumentException e) {
            LOG.error(String.format("Migration of ItemId failed. Original ID: %s, Migrated ID: %s", originalId, migratedId), (Throwable)e);
        }
    }
}

