/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.document.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import de.justsoftware.drive.business.change.ChangeTrigger;
import de.justsoftware.drive.business.change.ChangeWithTriggers;
import de.justsoftware.drive.business.change.DeleteFileTrigger;
import de.justsoftware.drive.business.change.DriveChangePublisher;
import de.justsoftware.drive.business.change.NewFileTrigger;
import de.justsoftware.drive.business.change.NewFolderTrigger;
import de.justsoftware.drive.business.document.ByteSourceWithFilename;
import de.justsoftware.drive.business.document.DocumentPublicity;
import de.justsoftware.drive.business.document.DocumentPublisher;
import de.justsoftware.drive.business.document.NameValidation;
import de.justsoftware.drive.business.document.NotSameItemException;
import de.justsoftware.drive.business.document.UniqueNameService;
import de.justsoftware.drive.business.document.impl.NonLockingDocumentTreeModificationService;
import de.justsoftware.drive.business.document.impl.NonLockingDocumentTreeModificationServiceImpl;
import de.justsoftware.drive.business.document.util.FileMetaInfoUtil;
import de.justsoftware.drive.business.event.DocumentTreeRestoredEvent;
import de.justsoftware.drive.business.event.DocumentsMovedEvent;
import de.justsoftware.drive.business.event.FilesCreatedEvent;
import de.justsoftware.drive.business.event.FilesDeletedEvent;
import de.justsoftware.drive.business.event.FilesRenamedEvent;
import de.justsoftware.drive.business.event.FoldersCreatedEvent;
import de.justsoftware.drive.business.event.FoldersDeletedEvent;
import de.justsoftware.drive.business.event.FoldersRenamedEvent;
import de.justsoftware.drive.business.event.NewFileVersionUploadedEvent;
import de.justsoftware.drive.business.file.FileStorageService;
import de.justsoftware.drive.business.item.ItemReadService;
import de.justsoftware.drive.common.change.model.ChangeBO;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.PublishedFilter;
import de.justsoftware.drive.common.file.model.FileInfo;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.common.folder.model.FolderVersionBO;
import de.justsoftware.drive.common.item.model.ItemBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.filepersistence.file.FileStorageDAO;
import de.justsoftware.drive.persistence.change.ChangeCreateModel;
import de.justsoftware.drive.persistence.change.ChangeDAO;
import de.justsoftware.drive.persistence.document.DocumentDAO;
import de.justsoftware.drive.persistence.document.DocumentVersionCreateModel;
import de.justsoftware.drive.persistence.document.DocumentVersionDAO;
import de.justsoftware.drive.persistence.file.DocumentSupportDAO;
import de.justsoftware.drive.persistence.file.FileDAO;
import de.justsoftware.drive.persistence.file.FileVersionCreateModel;
import de.justsoftware.drive.persistence.file.FileVersionDAO;
import de.justsoftware.drive.persistence.folder.FolderDAO;
import de.justsoftware.drive.persistence.folder.FolderVersionCreateModel;
import de.justsoftware.drive.persistence.folder.FolderVersionDAO;
import de.justsoftware.drive.persistence.folder.SubFolderDAO;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import io.micrometer.observation.annotation.Observed;
import java.net.URL;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Observed
@ParametersAreNonnullByDefault
@Service
public class NonLockingDocumentTreeModificationServiceImpl
implements NonLockingDocumentTreeModificationService {
    private static final Logger LOG = LoggerFactory.getLogger(NonLockingDocumentTreeModificationServiceImpl.class);
    private static final String NEW_ROOT_FOLDER_NAME = "root";
    private final FolderDAO _folderDAO;
    private final SubFolderDAO _subFolderDAO;
    private final FolderVersionDAO _folderVersionDAO;
    private final FileVersionDAO _fileVersionDAO;
    private final ChangeDAO _changeDAO;
    private final FileDAO _fileDAO;
    private final FileStorageDAO _fileStorageDAO;
    private final TransactionSupport _transactionSupport;
    private final UniqueNameService _uniqueNameService;
    private final EventBus _eventBus;
    private final Clock _clock;
    private final DocumentDAO _documentDAO;
    private final DocumentSupportDAO _documentSupportDAO;
    private final FileStorageService _fileStorageService;
    private final DriveChangePublisher _driveChangePublisher;
    private final ItemReadService _itemReadService;
    private final DocumentPublisher _documentPublisher;
    private final DocumentVersionDAO _documentVersionDAO;

    @Autowired
    public NonLockingDocumentTreeModificationServiceImpl(SubFolderDAO subFolderDAO, FolderDAO folderDAO, FolderVersionDAO folderVersionDAO, FileVersionDAO fileVersionDAO, ChangeDAO changeDAO, FileDAO fileDAO, DocumentSupportDAO documentSupportDAO, FileStorageDAO fileStorageDAO, TransactionSupport transactionSupport, UniqueNameService uniqueNameService, EventBus eventBus, DocumentDAO documentDAO, Clock clock, FileStorageService fileStorageService, ItemReadService itemReadService, DriveChangePublisher driveChangePublisher, DocumentPublisher documentPublisher, DocumentVersionDAO documentVersionDAO) {
        this._subFolderDAO = subFolderDAO;
        this._folderDAO = folderDAO;
        this._folderVersionDAO = folderVersionDAO;
        this._fileVersionDAO = fileVersionDAO;
        this._changeDAO = changeDAO;
        this._fileDAO = fileDAO;
        this._documentSupportDAO = documentSupportDAO;
        this._fileStorageDAO = fileStorageDAO;
        this._transactionSupport = transactionSupport;
        this._eventBus = eventBus;
        this._uniqueNameService = uniqueNameService;
        this._documentDAO = documentDAO;
        this._clock = clock;
        this._fileStorageService = fileStorageService;
        this._itemReadService = itemReadService;
        this._driveChangePublisher = driveChangePublisher;
        this._documentPublisher = documentPublisher;
        this._documentVersionDAO = documentVersionDAO;
    }

    @Nonnull
    private ChangeWithTriggers execute(AbstractModifyTreeActions action, ImmutableSet<? extends ChangeTrigger> triggers, @Nullable String purpose) {
        DocumentVersionId lastRootAndChangeId = action.getLastRoot();
        ChangeBO lastChange = (ChangeBO)this._changeDAO.getChangesByIds((Set)ImmutableSet.of((Object)lastRootAndChangeId)).get((Object)lastRootAndChangeId);
        FluentIterable folders = FluentIterable.from(action._newFolderVersions.values());
        Collection files = action._newFileVersions.values();
        FolderVersionCreateModel rootFolder = (FolderVersionCreateModel)Iterables.getOnlyElement((Iterable)folders.filter(f -> f.isRoot()));
        FluentIterable otherFolders = folders.filter(f -> !f.isRoot());
        DocumentVersionId changeId = rootFolder.getId();
        Consumer<DocumentVersionCreateModel> setChangeId = f -> f.setChangeId(changeId);
        otherFolders.forEach(setChangeId);
        files.forEach(setChangeId);
        ItemId itemId = lastChange.getItemId();
        ItemBO item = (ItemBO)this._itemReadService.getItems((Set)ImmutableSet.of((Object)itemId)).get((Object)itemId);
        int newChangeVersionNumber = lastChange.getVersion() + 1;
        ChangeCreateModel change = this._changeDAO.changeCreateModel().setFolderVersion(changeId).setItemId(itemId).setVersion(newChangeVersionNumber);
        boolean newVersionPublic = this.isNewVersionPublic(item);
        if (newVersionPublic) {
            change.setFirstPublishedDate(action._changeDate);
            Consumer<DocumentVersionCreateModel> setFirstPublishedChange = f -> f.setFirstPublishedChangeId(changeId);
            folders.forEach((Consumer)setFirstPublishedChange);
            files.forEach(setFirstPublishedChange);
        }
        for (Map.Entry entry : action.getOldChildren().entries()) {
            com.google.common.base.Optional parent = (com.google.common.base.Optional)action._oldToNew.get(entry.getKey());
            if (parent == null || !parent.isPresent()) continue;
            DocumentVersionId oldChildren = (DocumentVersionId)entry.getValue();
            com.google.common.base.Optional newId = (com.google.common.base.Optional)action._oldToNew.get(oldChildren);
            DocumentVersionId parentId = (DocumentVersionId)parent.get();
            if (newId == null) {
                action.addToFolder(parentId, oldChildren);
                continue;
            }
            if (!newId.isPresent()) continue;
            action.addToFolder(parentId, (DocumentVersionId)newId.get());
        }
        this._folderVersionDAO.insertFolderVersions((Iterable)FluentIterable.of((Object)rootFolder, (Object[])new FolderVersionCreateModel[0]).append((Iterable)otherFolders));
        this._fileVersionDAO.insertFileVersions(files);
        this._changeDAO.insertChanges((Iterable)ImmutableList.of((Object)change));
        this._subFolderDAO.insertFolderVersionRelations((SetMultimap)ImmutableSetMultimap.copyOf((Multimap)Multimaps.forMap((Map)action._newParents)).inverse());
        Sets.SetView allDocuments = Sets.union(action._newFileVersions.keySet(), action._newFolderVersions.keySet());
        this._documentDAO.updateLastVersions((Set)allDocuments);
        if (newVersionPublic) {
            this._documentDAO.updateLastPublicVersions((Set)allDocuments);
        }
        return new ChangeWithTriggers(changeId, itemId, newChangeVersionNumber, triggers, purpose, newVersionPublic, action._owner, action._changeDate);
    }

    private boolean isNewVersionPublic(ItemBO item) {
        return item == null || item.isNewVersionPublic();
    }

    @Nonnull
    private ModifyTreeActions copyParents(Set<DocumentId> targetFolders, Set<DocumentId> documents, PersonId owner, Instant changeDate) {
        ImmutableBiMap lastVersions = this._documentDAO.getLastVersions((Set)Sets.union(targetFolders, documents), PublishedFilter.PUBLISHED_OR_PRIVATE);
        ImmutableListMultimap paths = this._documentSupportDAO.getPath((Set)ImmutableSet.copyOf((Collection)lastVersions.values()), PublishedFilter.PUBLISHED_OR_PRIVATE);
        ImmutableMap oldDocuments = this._documentSupportDAO.getDocumentVersionsByIds((Set)ImmutableSet.copyOf((Collection)paths.values()));
        this.checkSameItem(oldDocuments);
        ModifyTreeActions actions = new ModifyTreeActions(this, paths, oldDocuments, owner, changeDate);
        HashSet visited = new HashSet();
        lastVersions.forEach((documentId, documentVersionId) -> FluentIterable.from((Iterable)actions._fullPaths.get(documentVersionId)).filter(FolderVersionBO.class).filter(pathElement -> !documentId.equals((Object)pathElement.getDocumentId()) || targetFolders.contains(documentId)).filter(pathElement -> visited.add(pathElement.getId())).forEach(arg_0 -> ((ModifyTreeActions)actions).newFolderVersion(arg_0)));
        return actions;
    }

    private void checkSameItem(ImmutableMap<DocumentVersionId, DocumentVersionBO> documents) {
        ImmutableSet itemIds = FluentIterable.from((Iterable)documents.values()).transform(DocumentVersionBO::getItemId).toSet();
        if (itemIds.size() > 1) {
            throw new NotSameItemException();
        }
    }

    public FolderVersionBO addSubFolder(DocumentId parent, String childName, PersonId owner) {
        ChangeCreatedResult result = (ChangeCreatedResult)this._transactionSupport.doInTransaction(() -> {
            Instant createDate = this._clock.instant();
            ModifyTreeActions actions = this.copyParents((Set)ImmutableSet.of((Object)parent), (Set)ImmutableSet.of(), owner, createDate);
            UniqueNameService.UniqueNameCache uniqueNameCache = this._uniqueNameService.forFolder(parent, NameValidation.THROW_EXCEPTION);
            FolderVersionCreateModel newFolderVersion = actions.createFolder(uniqueNameCache, parent, childName);
            NewFolderTrigger newFolderTrigger = new NewFolderTrigger(newFolderVersion.getDocumentId(), newFolderVersion.getName(), owner, createDate);
            ChangeWithTriggers changeWithTrigger = this.execute((AbstractModifyTreeActions)actions, ImmutableSet.of((Object)newFolderTrigger), null);
            this._transactionSupport.doAfterTransaction(() -> this._eventBus.post((Object)new FoldersCreatedEvent(newFolderVersion.getDocumentId(), newFolderVersion.getId())));
            return new ChangeCreatedResult(changeWithTrigger, (Object)newFolderVersion.getId());
        });
        this.notifyKafka(result);
        return (FolderVersionBO)this.loadAndPublishDocument((DocumentVersionId)result._resultValue, FolderVersionBO.class, result._changeWithTriggers);
    }

    @Nonnull
    private <D extends DocumentVersionBO> D loadAndPublishDocument(DocumentVersionId documentVersionId, Class<D> requiredClass, ChangeWithTriggers changeWithTriggers) {
        ImmutableListMultimap documents = this.publishChangedDocuments(changeWithTriggers);
        com.google.common.base.Optional result = FluentIterable.from((Iterable)documents.values()).filter(requiredClass).firstMatch(f -> documentVersionId.equals((Object)f.getId()));
        if (!result.isPresent()) {
            throw new IllegalStateException("document should be found");
        }
        return (D)((DocumentVersionBO)result.get());
    }

    @Nonnull
    private ImmutableListMultimap<DocumentVersionId, DocumentVersionBO> publishChangedDocuments(ChangeWithTriggers changeWithTriggers) {
        ImmutableSet publicities = this.publicitiesForChange(changeWithTriggers);
        DocumentVersionId changeId = changeWithTriggers.getId();
        ImmutableListMultimap documents = this._documentSupportDAO.getDocumentVersionsByChangeIds((Set)ImmutableSet.of((Object)changeId));
        documents.values().forEach(document -> this._documentPublisher.publishDocument(document, (Set)publicities));
        return documents;
    }

    public ImmutableMap<StorageId, FileVersionBO> addFileInfos(DocumentId parent, Iterable<FileInfo> fileInfos, PersonId owner, @Nullable String purpose) {
        return this.addFileInfos(parent, fileInfos, owner, purpose, NameValidation.CLEAN_NAME);
    }

    @Nonnull
    private ImmutableMap<StorageId, FileVersionBO> addFileInfos(DocumentId parent, Iterable<FileInfo> fileInfos, PersonId owner, @Nullable String purpose, NameValidation nameValidation) {
        ImmutableMap.Builder newVersions = ImmutableMap.builder();
        ChangeCreatedResult changeCreatedResult = (ChangeCreatedResult)this._transactionSupport.doInTransaction(() -> {
            Instant changeDate = this._clock.instant();
            UniqueNameService.UniqueNameCache uniqueNameCache = this._uniqueNameService.forFolder(parent, nameValidation);
            ModifyTreeActions actions = this.copyParents((Set)ImmutableSet.of((Object)parent), (Set)ImmutableSet.of(), owner, changeDate);
            ImmutableBiMap.Builder result = ImmutableBiMap.builder();
            ImmutableSet.Builder triggers = ImmutableSet.builder();
            for (FileInfo fileInfo : fileInfos) {
                Optional forcedId = fileInfo.getForceId();
                DocumentId fileId = this._fileDAO.createNewFile(forcedId);
                StorageId storageId = fileInfo.getStorageId();
                String name = uniqueNameCache.makeUnique(fileId, fileInfo.getName());
                FileVersionCreateModel newFileVersion = forcedId.isPresent() ? this._fileVersionDAO.fileVersionCreateModel(new DocumentVersionId((UUID)((DocumentId)forcedId.get()).getId())) : this._fileVersionDAO.fileVersionCreateModel();
                ((FileVersionCreateModel)((FileVersionCreateModel)((FileVersionCreateModel)((FileVersionCreateModel)newFileVersion.setDeleted(false).setDocumentId(fileId)).setFileSize(fileInfo.getFileSize()).setMimeType(fileInfo.getMimeType()).setStorageId(storageId).setName(name)).setVersion(1)).setOwner(owner)).setChangeDate(changeDate);
                actions.newFile(parent, newFileVersion);
                result.put((Object)fileInfo.getStorageId(), (Object)newFileVersion.getId());
                newVersions.put((Object)newFileVersion.getDocumentId(), (Object)newFileVersion.getId());
                triggers.add((Object)new NewFileTrigger(newFileVersion.getDocumentId(), newFileVersion.getId(), name, fileInfo.getFileSize(), fileInfo.getMimeType(), 1, owner, changeDate));
            }
            ChangeWithTriggers changeWithTriggers = this.execute((AbstractModifyTreeActions)actions, triggers.build(), purpose);
            return new ChangeCreatedResult(changeWithTriggers, (Object)result.build());
        });
        this._eventBus.post((Object)new FilesCreatedEvent(newVersions.build()));
        this.notifyKafka(changeCreatedResult);
        ImmutableListMultimap changedDocuments = this.publishChangedDocuments(changeCreatedResult._changeWithTriggers);
        return FluentIterable.from((Iterable)changedDocuments.values()).filter(FileVersionBO.class).filter(f -> ((ImmutableBiMap)changeCreatedResult._resultValue).containsValue((Object)f.getId())).uniqueIndex(FileVersionBO::getStorageId);
    }

    public DocumentVersionId addEmptyFile(DocumentId parent, String name, PersonId owner, @Nullable String purpose, NameValidation nameValidation) {
        ImmutableMap result = this.addFiles(parent, (Iterable)ImmutableList.of((Object)this.getByteSource(name)), owner, purpose, nameValidation);
        return (DocumentVersionId)Iterables.getOnlyElement((Iterable)result.keySet());
    }

    @Nonnull
    private ByteSourceWithFilename getByteSource(String name) {
        try {
            String extension = FilenameUtils.getExtension((String)name);
            URL fileURL = Resources.getResource((String)("newfiles/newfile." + extension));
            return new ByteSourceWithFilename(Resources.asByteSource((URL)fileURL), name, com.google.common.base.Optional.absent());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("File template not found for file" + name + ", using empty byte source");
            return new ByteSourceWithFilename(ByteSource.empty(), name, com.google.common.base.Optional.absent());
        }
    }

    public ImmutableMap<DocumentVersionId, ByteSourceWithFilename> addFiles(DocumentId parent, Iterable<ByteSourceWithFilename> sources, PersonId owner, @Nullable String purpose, NameValidation nameValidation) {
        ImmutableMap.Builder sourceMapBuilder = ImmutableMap.builder();
        ImmutableList.Builder infoBuilder = ImmutableList.builder();
        for (ByteSourceWithFilename source : sources) {
            FileInfo fileInfo = this._fileStorageService.storeFile(source);
            sourceMapBuilder.put((Object)fileInfo.getStorageId(), (Object)source);
            infoBuilder.add((Object)fileInfo);
        }
        try {
            ImmutableMap savedDocuments = this.addFileInfos(parent, (Iterable)infoBuilder.build(), owner, purpose, nameValidation);
            ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
            ImmutableMap sourceMap = sourceMapBuilder.build();
            for (Map.Entry entry : savedDocuments.entrySet()) {
                ByteSourceWithFilename byteSource = (ByteSourceWithFilename)sourceMap.get(entry.getKey());
                if (byteSource == null) continue;
                resultBuilder.put((Object)((FileVersionBO)entry.getValue()).getId(), (Object)byteSource);
            }
            return resultBuilder.build();
        }
        catch (RuntimeException e) {
            this._fileStorageService.deleteFilesSilently((Set)FluentIterable.from((Iterable)infoBuilder.build()).transform(FileInfo.TO_STORAGE_ID).filter(Predicates.notNull()).toSet());
            throw e;
        }
    }

    private void notifyKafka(ChangeCreatedResult<?> changeCreatedResult) {
        this.notifyKafka(changeCreatedResult._changeWithTriggers);
    }

    private void notifyKafka(ChangeWithTriggers changeWithTriggers) {
        this._driveChangePublisher.publishChange(changeWithTriggers);
    }

    @Nonnull
    private ImmutableSet<DocumentPublicity> publicitiesForChange(ChangeWithTriggers changeWithTriggers) {
        return changeWithTriggers.isPublic() ? ImmutableSet.of((Object)DocumentPublicity.PUBLIC, (Object)DocumentPublicity.PRIVATE) : ImmutableSet.of((Object)DocumentPublicity.PRIVATE);
    }

    public void createRootFolders(Map<ItemId, PersonId> owners, @Nullable String purpose) {
        ImmutableMap items = this._itemReadService.getItems(owners.keySet());
        LinkedList changesWithTriggers = new LinkedList();
        this._transactionSupport.doInTransaction(() -> {
            ImmutableSet.Builder publicRoots = ImmutableSet.builder();
            LinkedHashMap folders = new LinkedHashMap();
            ArrayList changes = new ArrayList(owners.size());
            owners.forEach((itemId, ownerId) -> {
                Instant changeDate = this._clock.instant();
                DocumentId folderId = this._folderDAO.createNewFolder();
                boolean newVersionPublic = this.isNewVersionPublic((ItemBO)items.get(itemId));
                FolderVersionCreateModel folderVersion = (FolderVersionCreateModel)((FolderVersionCreateModel)((FolderVersionCreateModel)((FolderVersionCreateModel)((FolderVersionCreateModel)this._folderVersionDAO.folderVersionCreateModel().setIsRoot(newVersionPublic).setName(NEW_ROOT_FOLDER_NAME)).setDocumentId(folderId)).setVersion(1)).setOwner(ownerId)).setChangeDate(changeDate);
                folders.put(folderId, folderVersion);
                ChangeCreateModel change = this._changeDAO.changeCreateModel().setItemId(itemId).setVersion(1).setFolderVersion(folderVersion.getId());
                if (newVersionPublic) {
                    change.setFirstPublishedDate(changeDate);
                    publicRoots.add((Object)folderId);
                }
                changes.add(change);
                changesWithTriggers.add(new ChangeWithTriggers(folderVersion.getId(), itemId, 1, ImmutableSet.of(), purpose, newVersionPublic, ownerId, changeDate));
            });
            this._folderVersionDAO.insertFolderVersions(folders.values());
            this._documentDAO.updateLastVersions(folders.keySet());
            this._documentDAO.updateLastPublicVersions((Set)publicRoots.build());
            this._changeDAO.insertChanges(changes);
        });
        this._transactionSupport.doAfterTransaction(() -> changesWithTriggers.forEach(arg_0 -> this.notifyKafka(arg_0)));
    }

    public DocumentVersionId deleteDocument(DocumentId documentId, PersonId owner) {
        ChangeCreatedResult result = (ChangeCreatedResult)this._transactionSupport.doInTransaction(() -> {
            Instant changeDate = this._clock.instant();
            ModifyTreeActions actions = this.copyParents((Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)documentId), owner, changeDate);
            actions.delete(documentId);
            DocumentVersionBO deletedDocument = actions.getOldDocumentVersion(documentId);
            ImmutableSet triggers = (ImmutableSet)deletedDocument.accept(file -> ImmutableSet.of((Object)new DeleteFileTrigger(documentId)), folder -> ImmutableSet.of());
            ChangeWithTriggers changeWithTriggers = this.execute((AbstractModifyTreeActions)actions, triggers, null);
            return new ChangeCreatedResult(changeWithTriggers, (Object)deletedDocument);
        });
        ChangeWithTriggers changeWithTriggers = result._changeWithTriggers;
        ImmutableSet publicities = this.publicitiesForChange(changeWithTriggers);
        this._transactionSupport.doAfterTransaction(() -> {
            this._eventBus.post(((DocumentVersionBO)result._resultValue).accept(file -> new FilesDeletedEvent(file.getDocumentId(), file.getId()), folder -> new FoldersDeletedEvent(folder.getDocumentId(), folder.getId())));
            this.notifyKafka(result);
            this._documentPublisher.deleteDocument(documentId, (Set)publicities);
            this.publishChangedDocuments(changeWithTriggers);
        });
        DocumentVersionBO deletedDocument = (DocumentVersionBO)result._resultValue;
        deletedDocument.accept(file -> this, folder -> {
            ImmutableSetMultimap children = this._documentSupportDAO.getFolderContentsRecursive((Set)ImmutableSet.of((Object)folder.getId()));
            ImmutableMap documentIdsOfChildren = this._documentVersionDAO.getDocumentIdsOfVersions((Set)children.inverse().keySet());
            documentIdsOfChildren.values().forEach(docId -> this._documentPublisher.deleteDocument(docId, (Set)publicities));
            return this;
        });
        return changeWithTriggers.getId();
    }

    public FileVersionBO renameFile(DocumentId fileId, PersonId owner, String newName) {
        ChangeCreatedResult result = (ChangeCreatedResult)this._transactionSupport.doInTransaction(() -> {
            Instant changeDate = this._clock.instant();
            ModifyTreeActions actions = this.copyParents((Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)fileId), owner, changeDate);
            String uniqueChildName = actions.makeUnique(fileId, newName, NameValidation.THROW_EXCEPTION);
            FileVersionBO currentFile = actions.getOldFileVersion(fileId);
            FileVersionCreateModel newFileVersion = (FileVersionCreateModel)actions.newFileVersion(currentFile).setName(uniqueChildName);
            NewFileTrigger newFileTrigger = new NewFileTrigger(fileId, newFileVersion.getId(), uniqueChildName, currentFile.getFileSize(), currentFile.getMimeType(), newFileVersion.getVersion(), owner, changeDate);
            ChangeWithTriggers changeWithTriggers = this.execute((AbstractModifyTreeActions)actions, ImmutableSet.of((Object)newFileTrigger), null);
            this._transactionSupport.doAfterTransaction(() -> this._eventBus.post((Object)new FilesRenamedEvent(fileId, newFileVersion.getId())));
            return new ChangeCreatedResult(changeWithTriggers, (Object)newFileVersion.getId());
        });
        this.notifyKafka(result);
        return (FileVersionBO)this.loadAndPublishDocument((DocumentVersionId)result._resultValue, FileVersionBO.class, result._changeWithTriggers);
    }

    public FolderVersionBO renameFolder(DocumentId folderId, PersonId owner, String newName) {
        ChangeCreatedResult result = (ChangeCreatedResult)this._transactionSupport.doInTransaction(() -> {
            Instant changeDate = this._clock.instant();
            ModifyTreeActions actions = this.copyParents((Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)folderId), owner, changeDate);
            String uniqueChildName = actions.makeUnique(folderId, newName, NameValidation.THROW_EXCEPTION);
            FolderVersionCreateModel newFolderVersion = (FolderVersionCreateModel)actions.newFolderVersion(actions.getOldFolderVersion(folderId)).setName(uniqueChildName);
            NewFolderTrigger newFolderTrigger = new NewFolderTrigger(folderId, uniqueChildName, owner, changeDate);
            ChangeWithTriggers changeWithTriggers = this.execute((AbstractModifyTreeActions)actions, ImmutableSet.of((Object)newFolderTrigger), null);
            this._transactionSupport.doAfterTransaction(() -> this._eventBus.post((Object)new FoldersRenamedEvent(folderId, newFolderVersion.getId())));
            return new ChangeCreatedResult(changeWithTriggers, (Object)newFolderVersion.getId());
        });
        this.notifyKafka(result);
        return (FolderVersionBO)this.loadAndPublishDocument((DocumentVersionId)result._resultValue, FolderVersionBO.class, result._changeWithTriggers);
    }

    public ImmutableListMultimap<DocumentId, FileVersionBO> rollbackFiles(Set<DocumentId> fileIds) {
        ImmutableListMultimap result = (ImmutableListMultimap)this._transactionSupport.doInTransaction(() -> {
            ImmutableListMultimap versions = this._documentSupportDAO.deleteFiles(fileIds);
            ImmutableListMultimap deleteByStorageId = Multimaps.index((Iterable)versions.values(), FileVersionBO::getStorageId);
            this._fileStorageService.deleteFilesWithTransactionLog((Multimap)deleteByStorageId);
            Map lastVersions = Maps.transformValues((Map)versions.asMap(), (Function)Functions.compose(DocumentVersionBO::getId, Iterables::getLast));
            this._transactionSupport.doAfterTransaction(() -> this._eventBus.post((Object)new FilesDeletedEvent(ImmutableMap.copyOf((Map)lastVersions))));
            return versions;
        });
        result.keySet().forEach(fileId -> this._documentPublisher.deleteDocument(fileId, (Set)ImmutableSet.of((Object)DocumentPublicity.PRIVATE, (Object)DocumentPublicity.PUBLIC)));
        return result;
    }

    public FileVersionBO uploadNewFileVersion(DocumentId fileId, ByteSourceWithFilename source, PersonId owner, String purpose) {
        ImmutableMap.Builder mappedSources = ImmutableMap.builder();
        try {
            ChangeCreatedResult result = (ChangeCreatedResult)this._transactionSupport.doInTransaction(() -> {
                Instant changeDate = this._clock.instant();
                ModifyTreeActions actions = this.copyParents((Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)fileId), owner, changeDate);
                String name = actions.makeUnique(fileId, source.getFilename(), NameValidation.CLEAN_NAME);
                String mimeType = FileMetaInfoUtil.getMimeTypeFromSource((String)source.getFilename(), (ByteSource)source.getByteSource());
                String fileExtension = FileMetaInfoUtil.getFileExtension((String)source.getFilename(), (String)mimeType);
                StorageId storageId = this._fileStorageDAO.store(fileExtension, source.getByteSource());
                mappedSources.put((Object)storageId, (Object)source);
                FileVersionCreateModel newFileVersion = (FileVersionCreateModel)actions.newFileVersion(actions.getOldFileVersion(fileId)).setFileSize(source.size()).setMimeType(mimeType).setStorageId(storageId).setName(name);
                NewFileTrigger newFileTrigger = new NewFileTrigger(fileId, newFileVersion.getId(), name, source.size(), mimeType, newFileVersion.getVersion(), owner, changeDate);
                ChangeWithTriggers changeWithTriggers = this.execute((AbstractModifyTreeActions)actions, ImmutableSet.of((Object)newFileTrigger), purpose);
                DocumentVersionId newVersionId = newFileVersion.getId();
                this._transactionSupport.doAfterTransaction(() -> this._eventBus.post((Object)new NewFileVersionUploadedEvent(fileId, newVersionId)));
                return new ChangeCreatedResult(changeWithTriggers, (Object)newVersionId);
            });
            this.notifyKafka(result);
            return (FileVersionBO)this.loadAndPublishDocument((DocumentVersionId)result._resultValue, FileVersionBO.class, result._changeWithTriggers);
        }
        catch (RuntimeException e) {
            this._fileStorageService.deleteFilesSilently((Set)mappedSources.build().keySet());
            throw e;
        }
    }

    public void moveToFolder(DocumentId targetFolderId, Set<DocumentId> documents, PersonId personId) {
        UniqueNameService.UniqueNameCache uniqueNameCache = this._uniqueNameService.forFolder(targetFolderId, NameValidation.CLEAN_NAME);
        com.google.common.base.Optional result = (com.google.common.base.Optional)this._transactionSupport.doInTransaction(() -> {
            ModifyTreeActions actions = this.copyParents((Set)ImmutableSet.of((Object)targetFolderId), documents, personId, this._clock.instant());
            ImmutableSet documentsToMove = FluentIterable.from((Iterable)documents).filter(documentId -> !targetFolderId.equals((Object)actions.getParentFolder(documentId))).toSet();
            if (documentsToMove.isEmpty()) {
                return com.google.common.base.Optional.absent();
            }
            for (DocumentId documentId2 : documentsToMove) {
                String newName;
                DocumentVersionBO old = actions.getOldDocumentVersion(documentId2);
                String currentName = old.getName();
                if (!Objects.equals(currentName, newName = uniqueNameCache.makeUnique(documentId2, currentName))) {
                    DocumentVersionCreateModel renamedDocument = (DocumentVersionCreateModel)old.accept(arg_0 -> ((ModifyTreeActions)actions).newFileVersion(arg_0), arg_0 -> ((ModifyTreeActions)actions).newFolderVersion(arg_0));
                    renamedDocument.setName(newName);
                }
                actions.addToFolder(targetFolderId, documentId2);
            }
            ChangeWithTriggers changeWithTriggers = this.execute((AbstractModifyTreeActions)actions, ImmutableSet.of(), null);
            this._transactionSupport.doAfterTransaction(() -> this._eventBus.post((Object)new DocumentsMovedEvent(ImmutableMap.copyOf((Map)Maps.filterKeys((Map)actions._byDocumentId, documents::contains)))));
            return com.google.common.base.Optional.of((Object)changeWithTriggers);
        });
        if (result.isPresent()) {
            ChangeWithTriggers changeWithTriggers = (ChangeWithTriggers)result.get();
            this.notifyKafka(changeWithTriggers);
            this.publishChangedDocuments(changeWithTriggers);
        }
    }

    public void copyToFolder(DocumentId targetFolderId, Map<DocumentId, PublishedFilter> documents, PersonId personId) {
        if (documents.isEmpty()) {
            return;
        }
        ImmutableBiMap.Builder lastVersionsBuilder = ImmutableBiMap.builder();
        for (PublishedFilter filter : PublishedFilter.values()) {
            Set docs = Maps.filterValues(documents, (Predicate)Predicates.equalTo((Object)filter)).keySet();
            lastVersionsBuilder.putAll((Map)this._documentDAO.getLastVersions(docs, filter));
        }
        ImmutableBiMap lastVersions = lastVersionsBuilder.build();
        ImmutableMap srcDocuments = this._documentSupportDAO.getDocumentVersionsByIds((Set)lastVersions.values());
        UniqueNameService.UniqueNameCache uniqueNameCache = this._uniqueNameService.forFolder(targetFolderId, NameValidation.CLEAN_NAME);
        ChangeWithTriggers result = (ChangeWithTriggers)this._transactionSupport.doInTransaction(() -> {
            ModifyTreeActions actions = this.copyParents((Set)ImmutableSet.of((Object)targetFolderId), (Set)ImmutableSet.of(), personId, this._clock.instant());
            HashMap<DocumentVersionId, DocumentId> queue = new HashMap<DocumentVersionId, DocumentId>();
            CopyVisitor initial = new CopyVisitor(actions, queue, targetFolderId, uniqueNameCache);
            srcDocuments.values().forEach(docVersion -> docVersion.accept((DocumentVersionBO.Visitor)initial));
            UniqueNameService.UniqueNameCache uc = (documentId, name) -> name;
            while (!queue.isEmpty()) {
                HashMap newQueue = new HashMap();
                ImmutableSetMultimap children = this._subFolderDAO.getSubFoldersByIds(queue.keySet());
                ImmutableMap oldChildren = this._documentSupportDAO.getDocumentVersionsByIds((Set)children.inverse().keySet());
                queue.forEach((parentFolderVersionId, parentFolderId) -> {
                    CopyVisitor copyVisitor = new CopyVisitor(actions, newQueue, parentFolderId, uc);
                    FluentIterable.from((Iterable)children.get(parentFolderVersionId)).transform(arg_0 -> ((ImmutableMap)oldChildren).get(arg_0)).forEach(docVersion -> docVersion.accept((DocumentVersionBO.Visitor)copyVisitor));
                });
                queue = newQueue;
            }
            ChangeWithTriggers changeWithTriggers = this.execute((AbstractModifyTreeActions)actions, ImmutableSet.of(), null);
            ImmutableMap newVersions = (ImmutableMap)actions.getNewFileVersions().values().stream().collect(ImmutableMap.toImmutableMap(DocumentVersionCreateModel::getDocumentId, DocumentVersionCreateModel::getId));
            this._transactionSupport.doAfterTransaction(() -> this._eventBus.post((Object)new FilesCreatedEvent(newVersions)));
            return changeWithTriggers;
        });
        this.notifyKafka(result);
        this.publishChangedDocuments(result);
    }

    public ChangeBO restoreVersion(DocumentVersionId changeIdToRestore, PersonId actor, String purpose) {
        ChangeBO changeToRestore = (ChangeBO)this._changeDAO.getChangesByIds((Set)ImmutableSet.of((Object)changeIdToRestore)).get((Object)changeIdToRestore);
        if (changeToRestore == null) {
            return null;
        }
        ItemId itemId = changeToRestore.getItemId();
        ChangeBO newestChange = (ChangeBO)this._changeDAO.getNewestChangePerItem((Set)ImmutableSet.of((Object)itemId), PublishedFilter.PUBLISHED_OR_PRIVATE).get((Object)itemId);
        if (newestChange == null) {
            return null;
        }
        DocumentVersionId newestChangeId = newestChange.getId();
        if (Objects.equals(newestChangeId, changeIdToRestore)) {
            return newestChange;
        }
        RestoreVersionCalculator calculator = new RestoreVersionCalculator(this, newestChangeId, actor, this._clock.instant());
        calculator.init(changeIdToRestore).run();
        if (calculator._result._newFolderVersions.isEmpty() && calculator._result._newFileVersions.isEmpty()) {
            return newestChange;
        }
        ChangeWithTriggers result = (ChangeWithTriggers)this._transactionSupport.doInTransaction(() -> {
            ChangeWithTriggers changeWithTriggers = this.execute(calculator._result, ImmutableSet.of(), purpose);
            this._eventBus.post((Object)new DocumentTreeRestoredEvent(itemId));
            return changeWithTriggers;
        });
        this.notifyKafka(result);
        DocumentVersionId resultId = result.getId();
        ChangeBO restoredChange = (ChangeBO)Preconditions.checkNotNull((Object)((ChangeBO)this._changeDAO.getChangesByIds((Set)ImmutableSet.of((Object)resultId)).get((Object)resultId)));
        ImmutableSet publicities = restoredChange.isPublic() ? ImmutableSet.of((Object)DocumentPublicity.PRIVATE, (Object)DocumentPublicity.PUBLIC) : ImmutableSet.of((Object)DocumentPublicity.PRIVATE);
        this._documentPublisher.publishItems((Set)ImmutableSet.of((Object)itemId), (Map)ImmutableMap.of((Object)itemId, (Object)restoredChange), (Set)publicities);
        return restoredChange;
    }
}

