/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.config.security;

import de.justsoftware.chat.config.security.JustOpaqueTokenIntrospector;
import de.justsoftware.chat.config.security.WebSecurityConfiguration;
import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\u00072\b\b\u0001\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017\u00a8\u0006\u000f"}, d2={"Lde/justsoftware/chat/config/security/WebSecurityConfiguration;", "", "<init>", "()V", "configureSecurity", "Lorg/springframework/security/web/SecurityFilterChain;", "checkTokenEndpoint", "", "clientId", "clientSecret", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "jwtVerifier", "Lde/justsoftware/jwtfilter/verifier/JwtVerifier;", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nWebSecurityConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSecurityConfiguration.kt\nde/justsoftware/chat/config/security/WebSecurityConfiguration\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,68:1\n11102#2:69\n11437#2,3:70\n*S KotlinDebug\n*F\n+ 1 WebSecurityConfiguration.kt\nde/justsoftware/chat/config/security/WebSecurityConfiguration\n*L\n33#1:69\n33#1:70,3\n*E\n"})
public class WebSecurityConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String INTERNAL_API = "/internal/**";
    @NotNull
    private static final String[] SWAGGER_RESOURCES;

    /*
     * WARNING - void declaration
     */
    @Bean
    @NotNull
    public SecurityFilterChain configureSecurity(@Value(value="${just.chat.oauth2.resource.check-token-endpoint}") @NotNull String checkTokenEndpoint, @Value(value="${just.chat.oauth2.resource.client-id}") @NotNull String clientId, @Value(value="${just.chat.oauth2.resource.client-secret}") @NotNull String clientSecret, @NotNull HttpSecurity http, @NotNull JwtVerifier jwtVerifier) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)checkTokenEndpoint, (String)"checkTokenEndpoint");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)jwtVerifier, (String)"jwtVerifier");
        Object[] objectArray = ArraysKt.plus((Object[])SWAGGER_RESOURCES, (Object)INTERNAL_API);
        JwtAuthenticationProcessingFilter jwtAuthenticationProcessingFilter = new JwtAuthenticationProcessingFilter(jwtVerifier);
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AntPathRequestMatcher((String)p0));
        }
        List list = (List)destination$iv$iv;
        JwtAuthenticationProcessingFilter jwtAuthenticationProcessingFilter2 = jwtAuthenticationProcessingFilter.applyIgnoreFilterMatcher((RequestMatcher)new OrRequestMatcher(list));
        Intrinsics.checkNotNullExpressionValue((Object)jwtAuthenticationProcessingFilter2, (String)"applyIgnoreFilterMatcher(...)");
        JwtAuthenticationProcessingFilter jwt = jwtAuthenticationProcessingFilter2;
        http.sessionManagement(WebSecurityConfiguration::configureSecurity$lambda$0).exceptionHandling(Customizer.withDefaults()).csrf(WebSecurityConfiguration::configureSecurity$lambda$1).headers(WebSecurityConfiguration::configureSecurity$lambda$2).anonymous(Customizer.withDefaults()).authorizeHttpRequests(WebSecurityConfiguration::configureSecurity$lambda$3).oauth2ResourceServer(arg_0 -> WebSecurityConfiguration.configureSecurity$lambda$5(checkTokenEndpoint, clientId, clientSecret, arg_0)).addFilterAfter((Filter)jwt, AbstractPreAuthenticatedProcessingFilter.class);
        Object object = http.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    private static final void configureSecurity$lambda$0(SessionManagementConfigurer it) {
        it.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }

    private static final void configureSecurity$lambda$1(CsrfConfigurer it) {
        it.disable();
    }

    private static final void configureSecurity$lambda$2(HeadersConfigurer it) {
        it.cacheControl(Customizer.withDefaults());
    }

    private static final void configureSecurity$lambda$3(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry it) {
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.addSpread((Object)SWAGGER_RESOURCES);
        spreadBuilder.add((Object)INTERNAL_API);
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]))).permitAll();
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.anyRequest()).fullyAuthenticated();
    }

    private static final void configureSecurity$lambda$5$lambda$4(String $checkTokenEndpoint, String $clientId, String $clientSecret, OAuth2ResourceServerConfigurer.OpaqueTokenConfigurer opaqueTokenCustomizer) {
        Intrinsics.checkNotNullParameter((Object)$checkTokenEndpoint, (String)"$checkTokenEndpoint");
        Intrinsics.checkNotNullParameter((Object)$clientId, (String)"$clientId");
        Intrinsics.checkNotNullParameter((Object)$clientSecret, (String)"$clientSecret");
        JustOpaqueTokenIntrospector justTokenIntrospector = new JustOpaqueTokenIntrospector($checkTokenEndpoint, $clientId, $clientSecret);
        opaqueTokenCustomizer.introspector((OpaqueTokenIntrospector)justTokenIntrospector);
    }

    private static final void configureSecurity$lambda$5(String $checkTokenEndpoint, String $clientId, String $clientSecret, OAuth2ResourceServerConfigurer resourceServerCustomizer) {
        Intrinsics.checkNotNullParameter((Object)$checkTokenEndpoint, (String)"$checkTokenEndpoint");
        Intrinsics.checkNotNullParameter((Object)$clientId, (String)"$clientId");
        Intrinsics.checkNotNullParameter((Object)$clientSecret, (String)"$clientSecret");
        resourceServerCustomizer.opaqueToken(arg_0 -> WebSecurityConfiguration.configureSecurity$lambda$5$lambda$4($checkTokenEndpoint, $clientId, $clientSecret, arg_0));
    }

    static {
        String[] stringArray = new String[]{"/v3/api-docs/**", "/swagger-ui/**"};
        SWAGGER_RESOURCES = stringArray;
    }
}

