/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.oauth2;

import de.justsoftware.authorization.oauth2.MobileClientRefreshTokenAuthenticationProvider;
import de.justsoftware.authorization.oauth2.MobileClientRefreshTokenAuthenticationToken;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;

/*
 * Exception performing whole class analysis ignored.
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0016\u0010\t\u001a\u00020\n2\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/justsoftware/authorization/oauth2/MobileClientRefreshTokenAuthenticationProvider;", "Lorg/springframework/security/authentication/AuthenticationProvider;", "registeredClientRepository", "Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClientRepository;", "<init>", "(Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClientRepository;)V", "authenticate", "Lorg/springframework/security/core/Authentication;", "authentication", "supports", "", "Ljava/lang/Class;", "Companion", "just-authorization-server"})
public final class MobileClientRefreshTokenAuthenticationProvider
implements AuthenticationProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RegisteredClientRepository registeredClientRepository;

    public MobileClientRefreshTokenAuthenticationProvider(@NotNull RegisteredClientRepository registeredClientRepository) {
        Intrinsics.checkNotNullParameter((Object)registeredClientRepository, (String)"registeredClientRepository");
        this.registeredClientRepository = registeredClientRepository;
    }

    @Nullable
    public Authentication authenticate(@NotNull Authentication authentication) throws AuthenticationException {
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        MobileClientRefreshTokenAuthenticationToken publicClientAuthentication = (MobileClientRefreshTokenAuthenticationToken)authentication;
        if (!Intrinsics.areEqual((Object)ClientAuthenticationMethod.NONE, (Object)publicClientAuthentication.getClientAuthenticationMethod())) {
            return null;
        }
        String clientId = publicClientAuthentication.getPrincipal().toString();
        RegisteredClient registeredClient = this.registeredClientRepository.findByClientId(clientId);
        if (registeredClient == null) {
            Companion.access$throwInvalidClient((Companion)Companion, (String)"client_id");
        }
        RegisteredClient registeredClient2 = registeredClient;
        Intrinsics.checkNotNull((Object)registeredClient2);
        if (!registeredClient2.getClientAuthenticationMethods().contains(publicClientAuthentication.getClientAuthenticationMethod())) {
            Companion.access$throwInvalidClient((Companion)Companion, (String)"authentication_method");
        }
        return (Authentication)new MobileClientRefreshTokenAuthenticationToken(registeredClient);
    }

    public boolean supports(@Nullable Class<?> authentication) {
        return authentication != null && MobileClientRefreshTokenAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

