/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.config;

import de.justsoftware.authorization.config.JustOauthClients;
import java.time.Duration;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;
import org.springframework.security.oauth2.server.authorization.settings.OAuth2TokenFormat;
import org.springframework.security.oauth2.server.authorization.settings.TokenSettings;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019BK\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0001\u0010\b\u001a\u00020\u0003\u0012\b\b\u0001\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u0016\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u0017\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u0018\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u000e\u0010\b\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lde/justsoftware/authorization/config/JustOauthClients;", "", "systemDomainPrefix", "", "mobileLoginAccessTokenValidityInSeconds", "", "mobileLoginRefreshTokenValidityInSeconds", "introspectionClientId", "internalClientSecret", "justLoginClientSecret", "passwordEncoder", "Lorg/springframework/security/crypto/password/PasswordEncoder;", "<init>", "(Ljava/lang/String;JJLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/springframework/security/crypto/password/PasswordEncoder;)V", "getSystemDomainPrefix", "()Ljava/lang/String;", "getIntrospectionClientId", "getPasswordEncoder", "()Lorg/springframework/security/crypto/password/PasswordEncoder;", "gatewayIntrospectionClient", "Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClient;", "id", "toroJustLoginClient", "toroMobileLoginClient", "swaggerClient", "Companion", "just-authorization-server"})
public class JustOauthClients {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String systemDomainPrefix;
    private final long mobileLoginAccessTokenValidityInSeconds;
    private final long mobileLoginRefreshTokenValidityInSeconds;
    @NotNull
    private final String introspectionClientId;
    @NotNull
    private final String internalClientSecret;
    @NotNull
    private final String justLoginClientSecret;
    @NotNull
    private final PasswordEncoder passwordEncoder;
    @NotNull
    public static final String JUST_TORO_MOBILE_LOGIN_CLIENT_ID = "just-login-mobile";
    @NotNull
    public static final String JUST_TORO_LOGIN_CLIENT_ID = "just-login";
    @NotNull
    public static final String SWAGGER_CLIENT_ID = "swagger";
    @NotNull
    private static final Set<String> MOBILE_CLIENT_IDS = SetsKt.setOf((Object)"just-login-mobile");
    private static final long SWAGGER_ACCESS_TOKEN_LIFETIME_IN_MINUTES = 60L;

    public JustOauthClients(@Value(value="${just.common.system.domainprefix}") @NotNull String systemDomainPrefix, @Value(value="${just.login.mobile.access_token_validity_seconds:28800}") long mobileLoginAccessTokenValidityInSeconds, @Value(value="${just.login.mobile.refresh_token_validity_seconds:15778800}") long mobileLoginRefreshTokenValidityInSeconds, @Value(value="${just.toro.oauth2.resource.client_id}") @NotNull String introspectionClientId, @Value(value="${just.toro.oauth2.resource.client_secret}") @NotNull String internalClientSecret, @Value(value="${just.toro.oauth.clientSecret}") @NotNull String justLoginClientSecret, @NotNull PasswordEncoder passwordEncoder) {
        Intrinsics.checkNotNullParameter((Object)systemDomainPrefix, (String)"systemDomainPrefix");
        Intrinsics.checkNotNullParameter((Object)introspectionClientId, (String)"introspectionClientId");
        Intrinsics.checkNotNullParameter((Object)internalClientSecret, (String)"internalClientSecret");
        Intrinsics.checkNotNullParameter((Object)justLoginClientSecret, (String)"justLoginClientSecret");
        Intrinsics.checkNotNullParameter((Object)passwordEncoder, (String)"passwordEncoder");
        this.systemDomainPrefix = systemDomainPrefix;
        this.mobileLoginAccessTokenValidityInSeconds = mobileLoginAccessTokenValidityInSeconds;
        this.mobileLoginRefreshTokenValidityInSeconds = mobileLoginRefreshTokenValidityInSeconds;
        this.introspectionClientId = introspectionClientId;
        this.internalClientSecret = internalClientSecret;
        this.justLoginClientSecret = justLoginClientSecret;
        this.passwordEncoder = passwordEncoder;
    }

    @NotNull
    public String getSystemDomainPrefix() {
        return this.systemDomainPrefix;
    }

    @NotNull
    public String getIntrospectionClientId() {
        return this.introspectionClientId;
    }

    @NotNull
    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    @NotNull
    public RegisteredClient gatewayIntrospectionClient(@Nullable String id) {
        String string = id;
        if (string == null) {
            String string2 = UUID.randomUUID().toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        }
        String nonNullId = string;
        RegisteredClient registeredClient = RegisteredClient.withId((String)nonNullId).clientId(this.getIntrospectionClientId()).clientSecret(this.getPasswordEncoder().encode((CharSequence)this.internalClientSecret)).scope("api").authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_BASIC).tokenSettings(TokenSettings.builder().accessTokenFormat(OAuth2TokenFormat.REFERENCE).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)registeredClient, (String)"build(...)");
        return registeredClient;
    }

    @NotNull
    public RegisteredClient toroJustLoginClient(@Nullable String id) {
        String string = id;
        if (string == null) {
            String string2 = UUID.randomUUID().toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        }
        String nonNullId = string;
        RegisteredClient registeredClient = RegisteredClient.withId((String)nonNullId).clientId(JUST_TORO_LOGIN_CLIENT_ID).clientSecret(this.getPasswordEncoder().encode((CharSequence)this.justLoginClientSecret)).clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_BASIC).clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_POST).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).authorizationGrantType(AuthorizationGrantType.REFRESH_TOKEN).redirectUri(this.getSystemDomainPrefix() + "/login/oauth2/code/just").postLogoutRedirectUri(this.getSystemDomainPrefix() + "/just/loggedOut").scope("api").tokenSettings(TokenSettings.builder().accessTokenFormat(OAuth2TokenFormat.REFERENCE).build()).clientSettings(ClientSettings.builder().requireAuthorizationConsent(false).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)registeredClient, (String)"build(...)");
        return registeredClient;
    }

    @NotNull
    public RegisteredClient toroMobileLoginClient(@Nullable String id) {
        String string = id;
        if (string == null) {
            String string2 = UUID.randomUUID().toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        }
        String nonNullId = string;
        RegisteredClient registeredClient = RegisteredClient.withId((String)nonNullId).clientId(JUST_TORO_MOBILE_LOGIN_CLIENT_ID).clientAuthenticationMethod(ClientAuthenticationMethod.NONE).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).authorizationGrantType(AuthorizationGrantType.REFRESH_TOKEN).redirectUri("de.justsoftware.mobile.social://oauth2redirect/").redirectUri("de.justsoftware.mobile.justsocial://oauth2redirect").redirectUri("de.justsoftware.mobile.justsocial.debug://oauth2redirect").scope("api").tokenSettings(TokenSettings.builder().accessTokenFormat(OAuth2TokenFormat.REFERENCE).accessTokenTimeToLive(Duration.ofSeconds(this.mobileLoginAccessTokenValidityInSeconds)).refreshTokenTimeToLive(Duration.ofSeconds(this.mobileLoginRefreshTokenValidityInSeconds)).reuseRefreshTokens(false).build()).clientSettings(ClientSettings.builder().requireAuthorizationConsent(false).requireProofKey(true).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)registeredClient, (String)"build(...)");
        return registeredClient;
    }

    @NotNull
    public RegisteredClient swaggerClient(@Nullable String id) {
        String string = id;
        if (string == null) {
            String string2 = UUID.randomUUID().toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        }
        String nonNullId = string;
        RegisteredClient registeredClient = RegisteredClient.withId((String)nonNullId).clientId(SWAGGER_CLIENT_ID).clientAuthenticationMethod(ClientAuthenticationMethod.NONE).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).redirectUri(this.getSystemDomainPrefix() + "/toro/swagger-ui/oauth2-redirect.html").scope("api").tokenSettings(TokenSettings.builder().accessTokenFormat(OAuth2TokenFormat.REFERENCE).accessTokenTimeToLive(Duration.ofMinutes(60L)).build()).clientSettings(ClientSettings.builder().requireAuthorizationConsent(false).requireProofKey(true).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)registeredClient, (String)"build(...)");
        return registeredClient;
    }

    public static final /* synthetic */ Set access$getMOBILE_CLIENT_IDS$cp() {
        return MOBILE_CLIENT_IDS;
    }
}

